/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.rocksdb;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.storage.MvPartitionStorage;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.StorageRebalanceException;
import org.apache.ignite3.internal.storage.engine.MvPartitionMeta;
import org.apache.ignite3.internal.storage.engine.MvTableStorage;
import org.apache.ignite3.internal.storage.engine.StorageTableDescriptor;
import org.apache.ignite3.internal.storage.index.IndexStorage;
import org.apache.ignite3.internal.storage.index.StorageHashIndexDescriptor;
import org.apache.ignite3.internal.storage.index.StorageIndexDescriptorSupplier;
import org.apache.ignite3.internal.storage.index.StorageSortedIndexDescriptor;
import org.apache.ignite3.internal.storage.rocksdb.IgniteRocksDbException;
import org.apache.ignite3.internal.storage.rocksdb.RocksDbIndexes;
import org.apache.ignite3.internal.storage.rocksdb.RocksDbMvPartitionStorage;
import org.apache.ignite3.internal.storage.rocksdb.RocksDbStorageEngine;
import org.apache.ignite3.internal.storage.rocksdb.index.AbstractRocksDbIndexStorage;
import org.apache.ignite3.internal.storage.rocksdb.instance.SharedRocksDbInstance;
import org.apache.ignite3.internal.storage.util.MvPartitionStorages;
import org.apache.ignite3.internal.storage.util.StorageState;
import org.apache.ignite3.internal.storage.util.StorageUtils;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteBatch;

public class RocksDbTableStorage
implements MvTableStorage {
    private final SharedRocksDbInstance rocksDb;
    private final MvPartitionStorages<RocksDbMvPartitionStorage> mvPartitionStorages;
    private final RocksDbIndexes indexes;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicReference<StorageState> state = new AtomicReference<StorageState>(StorageState.RUNNABLE);
    private final StorageTableDescriptor tableDescriptor;
    private final StorageIndexDescriptorSupplier indexDescriptorSupplier;

    RocksDbTableStorage(SharedRocksDbInstance rocksDb, StorageTableDescriptor tableDescriptor, StorageIndexDescriptorSupplier indexDescriptorSupplier) {
        this.rocksDb = rocksDb;
        this.tableDescriptor = tableDescriptor;
        this.mvPartitionStorages = new MvPartitionStorages(tableDescriptor.getId(), tableDescriptor.getPartitions());
        this.indexes = new RocksDbIndexes(rocksDb, tableDescriptor.getId());
        this.indexDescriptorSupplier = indexDescriptorSupplier;
    }

    void start() {
        try {
            this.indexes.recoverIndexes(this.indexDescriptorSupplier);
        }
        catch (RocksDBException e) {
            throw new IgniteRocksDbException("Unable to recover indexes", e);
        }
    }

    public RocksDbStorageEngine engine() {
        return this.rocksDb.engine;
    }

    public RocksDB db() {
        return this.rocksDb.db;
    }

    ColumnFamilyHandle partitionCfHandle() {
        return this.rocksDb.partitionCf.handle();
    }

    ColumnFamilyHandle metaCfHandle() {
        return this.rocksDb.meta.columnFamily().handle();
    }

    ColumnFamilyHandle gcQueueHandle() {
        return this.rocksDb.gcQueueCf.handle();
    }

    ColumnFamilyHandle dataCfHandle() {
        return this.rocksDb.dataCf.handle();
    }

    ColumnFamilyHandle tombstonesHandle() {
        return this.rocksDb.tombstonesCf.handle();
    }

    public CompletableFuture<Void> awaitFlush(boolean schedule) {
        return this.busy(() -> this.rocksDb.flusher.awaitFlush(schedule));
    }

    private CompletableFuture<Void> stop(boolean destroy) {
        boolean transitionedToTerminalState;
        boolean bl = transitionedToTerminalState = destroy ? StorageUtils.transitionToDestroyedState(this.state) : StorageUtils.transitionToClosedState(this.state, this::createStorageInfo);
        if (!transitionedToTerminalState) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.busyLock.block();
        return this.mvPartitionStorages.getAllForCloseOrDestroy().thenAccept(partitionStorages -> {
            ArrayList<AutoCloseable> resources = new ArrayList<AutoCloseable>();
            if (destroy) {
                resources.addAll(this.indexes.getResourcesForDestroy());
                partitionStorages.forEach(mvPartitionStorage -> resources.add(mvPartitionStorage::transitionToDestroyedState));
            } else {
                resources.addAll(this.indexes.getResourcesForClose());
                partitionStorages.forEach(mvPartitionStorage -> resources.add(mvPartitionStorage::close));
            }
            try {
                IgniteUtils.closeAll(resources);
            }
            catch (Exception e) {
                throw new StorageException("Failed to stop RocksDB table storage: " + this.getTableId(), (Throwable)e);
            }
            if (destroy) {
                this.rocksDb.destroyTable(this.getTableId());
            }
        });
    }

    @Override
    public void close() throws StorageException {
        try {
            this.stop(false).get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new StorageException("Failed to stop RocksDB table storage: " + this.getTableId(), (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Void> destroy() {
        return this.stop(true);
    }

    @Override
    public CompletableFuture<MvPartitionStorage> createMvPartition(int partitionId) throws StorageException {
        return this.busy(() -> this.mvPartitionStorages.create(partitionId, partId -> {
            RocksDbMvPartitionStorage partition = new RocksDbMvPartitionStorage(this, partitionId);
            if (partition.lastAppliedIndex() == 0L) {
                partition.runConsistently(locker -> {
                    partition.lastApplied(partition.lastAppliedIndex(), partition.lastAppliedTerm());
                    return null;
                });
            }
            return partition;
        }));
    }

    @Override
    @Nullable
    public RocksDbMvPartitionStorage getMvPartition(int partitionId) {
        return this.busy(() -> this.mvPartitionStorages.get(partitionId));
    }

    @Override
    public CompletableFuture<Void> destroyPartition(int partitionId) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFutures.nullCompletedFuture();
        }
        try {
            CompletableFuture<Void> completableFuture = this.mvPartitionStorages.destroy(partitionId, mvPartitionStorage -> {
                CompletableFuture completableFuture;
                WriteBatch writeBatch = new WriteBatch();
                try {
                    mvPartitionStorage.transitionToDestroyedState();
                    mvPartitionStorage.destroyData(writeBatch);
                    this.indexes.destroyAllIndexesForPartition(partitionId, writeBatch);
                    this.rocksDb.db.write(SharedRocksDbInstance.DFLT_WRITE_OPTS, writeBatch);
                    completableFuture = CompletableFutures.nullCompletedFuture();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            writeBatch.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (RocksDBException e) {
                        throw new IgniteRocksDbException(String.format("Error when destroying storage: [%s]", this.mvPartitionStorages.createStorageInfo(partitionId)), e);
                    }
                }
                writeBatch.close();
                return completableFuture;
            });
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public void createSortedIndex(int partitionId, StorageSortedIndexDescriptor indexDescriptor) {
        this.busy(() -> {
            if (this.partitionExists(partitionId)) {
                this.indexes.createSortedIndex(partitionId, indexDescriptor);
            }
        });
    }

    @Override
    public void createHashIndex(int partitionId, StorageHashIndexDescriptor indexDescriptor) {
        this.busy(() -> {
            if (this.partitionExists(partitionId)) {
                this.indexes.createHashIndex(partitionId, indexDescriptor);
            }
        });
    }

    @Override
    public CompletableFuture<Void> destroyIndex(int indexId) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFutures.nullCompletedFuture();
        }
        try {
            this.indexes.destroyIndex(indexId);
            CompletableFuture<Void> completableFuture = CompletableFutures.nullCompletedFuture();
            return completableFuture;
        }
        catch (RocksDBException e) {
            throw new IgniteRocksDbException(String.format("Error when destroying index: %d", indexId), e);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public boolean isVolatile() {
        return false;
    }

    @Override
    public CompletableFuture<Void> startRebalancePartition(int partitionId) {
        return this.busy(() -> this.mvPartitionStorages.startRebalance(partitionId, mvPartitionStorage -> {
            CompletableFuture completableFuture;
            WriteBatch writeBatch = new WriteBatch();
            try {
                mvPartitionStorage.startRebalance(writeBatch);
                this.indexes.startRebalance(partitionId, writeBatch);
                this.rocksDb.db.write(SharedRocksDbInstance.DFLT_WRITE_OPTS, writeBatch);
                completableFuture = CompletableFutures.nullCompletedFuture();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        writeBatch.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (RocksDBException e) {
                    throw new StorageRebalanceException("Error when trying to start rebalancing storage: [{}]", (Throwable)e, mvPartitionStorage.createStorageInfo());
                }
            }
            writeBatch.close();
            return completableFuture;
        }));
    }

    @Override
    public CompletableFuture<Void> abortRebalancePartition(int partitionId) {
        return this.busy(() -> this.mvPartitionStorages.abortRebalance(partitionId, mvPartitionStorage -> {
            CompletableFuture completableFuture;
            WriteBatch writeBatch = new WriteBatch();
            try {
                mvPartitionStorage.abortRebalance(writeBatch);
                this.indexes.abortRebalance(partitionId, writeBatch);
                this.rocksDb.db.write(SharedRocksDbInstance.DFLT_WRITE_OPTS, writeBatch);
                completableFuture = CompletableFutures.nullCompletedFuture();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        writeBatch.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (RocksDBException e) {
                    throw new StorageRebalanceException("Error when trying to abort rebalancing storage: [{}]", (Throwable)e, mvPartitionStorage.createStorageInfo());
                }
            }
            writeBatch.close();
            return completableFuture;
        }));
    }

    @Override
    public CompletableFuture<Void> finishRebalancePartition(int partitionId, MvPartitionMeta partitionMeta) {
        return this.busy(() -> this.mvPartitionStorages.finishRebalance(partitionId, mvPartitionStorage -> {
            CompletableFuture completableFuture;
            WriteBatch writeBatch = new WriteBatch();
            try {
                mvPartitionStorage.finishRebalance(writeBatch, partitionMeta);
                this.indexes.finishRebalance(partitionId);
                this.rocksDb.db.write(SharedRocksDbInstance.DFLT_WRITE_OPTS, writeBatch);
                completableFuture = CompletableFutures.nullCompletedFuture();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        writeBatch.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (RocksDBException e) {
                    throw new StorageRebalanceException("Error when trying to finish rebalancing storage: [{}]", (Throwable)e, mvPartitionStorage.createStorageInfo());
                }
            }
            writeBatch.close();
            return completableFuture;
        }));
    }

    @Override
    public CompletableFuture<Void> clearPartition(int partitionId) {
        return this.busy(() -> this.mvPartitionStorages.clear(partitionId, mvPartitionStorage -> {
            List<AbstractRocksDbIndexStorage> indexStorages = this.indexes.getAllStorages(partitionId).collect(Collectors.toList());
            try {
                CompletableFuture completableFuture;
                WriteBatch writeBatch = new WriteBatch();
                try {
                    mvPartitionStorage.startCleanup(writeBatch);
                    for (AbstractRocksDbIndexStorage storage : indexStorages) {
                        storage.startCleanup(writeBatch);
                    }
                    this.rocksDb.db.write(SharedRocksDbInstance.DFLT_WRITE_OPTS, writeBatch);
                    completableFuture = CompletableFutures.nullCompletedFuture();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            writeBatch.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (RocksDBException e) {
                        throw new IgniteRocksDbException(String.format("Error when trying to cleanup storage: [%s]", mvPartitionStorage.createStorageInfo()), e);
                    }
                }
                writeBatch.close();
                return completableFuture;
            }
            finally {
                mvPartitionStorage.finishCleanup();
                indexStorages.forEach(AbstractRocksDbIndexStorage::finishCleanup);
            }
        }));
    }

    int getTableId() {
        return this.tableDescriptor.getId();
    }

    private void checkPartitionExists(int partitionId) {
        if (!this.partitionExists(partitionId)) {
            throw new StorageException(StorageUtils.createMissingMvPartitionErrorMessage(partitionId));
        }
    }

    private boolean partitionExists(int partitionId) {
        return this.mvPartitionStorages.get(partitionId) != null;
    }

    @Override
    @Nullable
    public IndexStorage getIndex(int partitionId, int indexId) {
        return this.busy(() -> {
            this.checkPartitionExists(partitionId);
            return this.indexes.getIndex(partitionId, indexId);
        });
    }

    @Override
    public StorageTableDescriptor getTableDescriptor() {
        return this.tableDescriptor;
    }

    private <V> V busy(Supplier<V> supplier) {
        if (!this.busyLock.enterBusy()) {
            StorageUtils.throwExceptionDependingOnStorageState(this.state.get(), this.createStorageInfo());
        }
        try {
            V v = supplier.get();
            return v;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private void busy(Runnable action) {
        if (!this.busyLock.enterBusy()) {
            StorageUtils.throwExceptionDependingOnStorageState(this.state.get(), this.createStorageInfo());
        }
        try {
            action.run();
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private String createStorageInfo() {
        return IgniteStringFormatter.format("tableId={}", this.getTableId());
    }
}

