/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv.tombstones.io;

import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.pagememory.io.IoVersions;
import org.apache.ignite3.internal.pagememory.io.PageIo;
import org.apache.ignite3.internal.pagememory.tree.BplusTree;
import org.apache.ignite3.internal.pagememory.tree.io.BplusIo;
import org.apache.ignite3.internal.pagememory.tree.io.BplusLeafIo;
import org.apache.ignite3.internal.pagememory.util.PageIdUtils;
import org.apache.ignite3.internal.pagememory.util.PageUtils;
import org.apache.ignite3.internal.storage.pagememory.mv.tombstones.io.TombstonesIo;
import org.apache.ignite3.internal.storage.tombstones.Tombstone;

public class TombstonesLeafIo
extends BplusLeafIo<Tombstone>
implements TombstonesIo {
    public static final IoVersions<TombstonesLeafIo> VERSIONS = new IoVersions((PageIo[])new TombstonesLeafIo[]{new TombstonesLeafIo(1)});

    private TombstonesLeafIo(int ver) {
        super(17, ver, 24);
    }

    @Override
    public void store(long dstPageAddr, int dstIdx, BplusIo<Tombstone> srcIo, long srcPageAddr, int srcIdx) {
        TombstonesIo.super.store(dstPageAddr, dstIdx, srcIo, srcPageAddr, srcIdx);
    }

    @Override
    public void storeByOffset(long pageAddr, int off, Tombstone row) {
        TombstonesIo.super.storeByOffset(pageAddr, off, row);
    }

    @Override
    public Tombstone getLookupRow(BplusTree<Tombstone, ?> tree, long pageAddr, int idx) {
        return this.getRow(pageAddr, idx, TombstonesLeafIo.getPartitionId(pageAddr));
    }

    private static int getPartitionId(long pageAddr) {
        long pageId = TombstonesLeafIo.getPageId(pageAddr);
        return PageIdUtils.partitionId(pageId);
    }

    public long timestampCompareTo(long pageAddr, int idx, HybridTimestamp timestamp) {
        int timestampOffset = this.offset(idx) + 16;
        return Long.compare(PageUtils.getLong(pageAddr, timestampOffset), timestamp.longValue());
    }
}

