/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv.io;

import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.pagememory.tree.io.BplusIo;
import org.apache.ignite3.internal.pagememory.util.PageUtils;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.pagememory.mv.UpdateLogKey;

public interface UpdateLogIo {
    public static final int ROW_TIMESTAMP_OFFSET = 0;
    public static final int ROW_ID_MSB_OFFSET = 8;
    public static final int ROW_ID_LSB_OFFSET = 16;
    public static final int SIZE_IN_BYTES = 24;

    public int offset(int var1);

    default public void store(long dstPageAddr, int dstIdx, BplusIo<UpdateLogKey> srcIo, long srcPageAddr, int srcIdx) {
        int dstOffset = this.offset(dstIdx);
        int srcOffset = srcIo.offset(srcIdx);
        PageUtils.copyMemory(srcPageAddr, (long)srcOffset, dstPageAddr, (long)dstOffset, 24L);
    }

    default public void storeByOffset(long pageAddr, int off, UpdateLogKey row) {
        PageUtils.putLong(pageAddr, off + 0, row.timestamp().longValue());
        PageUtils.putLong(pageAddr, off + 8, row.rowId().mostSignificantBits());
        PageUtils.putLong(pageAddr, off + 16, row.rowId().leastSignificantBits());
    }

    default public int compare(long pageAddr, int idx, UpdateLogKey row) {
        int offset = this.offset(idx);
        int cmp = Long.compare(PageUtils.getLong(pageAddr, offset + 0), row.timestamp().longValue());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Long.compare(PageUtils.getLong(pageAddr, offset + 8), row.rowId().mostSignificantBits());
        if (cmp != 0) {
            return cmp;
        }
        return Long.compare(PageUtils.getLong(pageAddr, offset + 16), row.rowId().leastSignificantBits());
    }

    default public UpdateLogKey getRow(long pageAddr, int idx, int partitionId) {
        int offset = this.offset(idx);
        long ts = PageUtils.getLong(pageAddr, offset + 0);
        long rowIdMsb = PageUtils.getLong(pageAddr, offset + 8);
        long rowIdLsb = PageUtils.getLong(pageAddr, offset + 16);
        return new UpdateLogKey(new RowId(partitionId, rowIdMsb, rowIdLsb), HybridTimestamp.hybridTimestamp(ts));
    }
}

