/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv;

import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.pagememory.io.DataPagePayload;
import org.apache.ignite3.internal.pagememory.util.PageUtils;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.pagememory.mv.WiLinkableRowVersion;
import org.apache.ignite3.internal.storage.pagememory.mv.WiLinkableRowVersionReader;
import org.jetbrains.annotations.Nullable;

class WiLinkableWriteIntentReader
extends WiLinkableRowVersionReader {
    private RowId rowId;

    WiLinkableWriteIntentReader(long link, int partitionId) {
        super(link, partitionId);
    }

    @Override
    public void readFromPage(long pageAddr, DataPagePayload payload) {
        super.readFromPage(pageAddr, payload);
        long rowIdMsb = PageUtils.getLong(pageAddr, payload.offset() + 21);
        long rowIdLsb = PageUtils.getLong(pageAddr, payload.offset() + 1);
        this.rowId = new RowId(this.partitionId, rowIdMsb, rowIdLsb);
    }

    @Override
    @Nullable
    protected HybridTimestamp readTimestamp(long pageAddr, int offset) {
        return null;
    }

    @Override
    public WiLinkableRowVersion createRowVersion(int valueSize, @Nullable BinaryRow value) {
        return new WiLinkableRowVersion(this.rowId, this.partitionId, this.link, null, this.nextLink, this.prevWiLink, this.nextWiLink, valueSize, value, this.isArchived);
    }
}

