/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.pagememory.util.PageUtils;
import org.apache.ignite3.internal.pagememory.util.PartitionlessLinks;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.pagememory.mv.RowVersion;
import org.apache.ignite3.internal.storage.pagememory.mv.RowVersionOperations;
import org.apache.ignite3.internal.storage.pagememory.mv.WiLinkableRowVersionOperations;
import org.apache.ignite3.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public final class WiLinkableRowVersion
extends RowVersion {
    public static final byte WRITE_INTENT_DATA_TYPE = 2;
    public static final byte COMMITTED_DATA_TYPE = 3;
    private static final int WRITE_INTENT_LINKS_SIZE_BYTES = 20;
    public static final int ROW_ID_LSB_OFFSET = 1;
    public static final int ROW_ID_MSB_OFFSET = 21;
    public static final int PREV_WRITE_INTENT_LINK_OFFSET = 29;
    public static final int NEXT_WRITE_INTENT_LINK_OFFSET = 35;
    public static final int VALUE_OFFSET = 41;
    @Nullable
    private final RowId rowId;
    private final long prevWriteIntentLink;
    private final long nextWriteIntentLink;

    public WiLinkableRowVersion(RowId rowId, int partitionId, long nextLink, long prevWriteIntentLink, long nextWriteIntentLink, @Nullable BinaryRow value, boolean isArchived) {
        this(rowId, partitionId, 0L, null, nextLink, prevWriteIntentLink, nextWriteIntentLink, value == null ? 0 : value.tupleSliceLength(), value, isArchived);
    }

    public WiLinkableRowVersion(@Nullable RowId rowId, int partitionId, long link, @Nullable HybridTimestamp timestamp, long nextLink, long prevWriteIntentLink, long nextWriteIntentLink, int valueSize, @Nullable BinaryRow value, boolean isArchived) {
        super(partitionId, link, timestamp, nextLink, valueSize, value, isArchived);
        assert (timestamp == null ^ rowId == null) : "Either timestamp or rowId must be null";
        this.rowId = rowId;
        this.prevWriteIntentLink = prevWriteIntentLink;
        this.nextWriteIntentLink = nextWriteIntentLink;
    }

    public RowId requiredRowId() {
        return Objects.requireNonNull(this.rowId);
    }

    public long nextWriteIntentLink() {
        return this.nextWriteIntentLink;
    }

    public long prevWriteIntentLink() {
        return this.prevWriteIntentLink;
    }

    @Override
    public int headerSize() {
        return super.headerSize() + 20;
    }

    @Override
    protected byte dataType() {
        return this.isWriteIntent() ? (byte)2 : 3;
    }

    private boolean isWriteIntent() {
        return this.timestamp() == null;
    }

    @Override
    protected int valueOffset() {
        return 41;
    }

    @Override
    protected void writeHeader(long pageAddr, int dataOff) {
        super.writeHeader(pageAddr, dataOff);
        if (this.isWriteIntent()) {
            assert (this.rowId != null);
            PageUtils.putLong(pageAddr, dataOff + 21, this.rowId.mostSignificantBits());
            PageUtils.putLong(pageAddr, dataOff + 1, this.rowId.leastSignificantBits());
        } else {
            assert (this.rowId == null);
            PageUtils.putLong(pageAddr, dataOff + 21, 0L);
        }
        PartitionlessLinks.writePartitionless(pageAddr + (long)dataOff + 29L, this.prevWriteIntentLink);
        PartitionlessLinks.writePartitionless(pageAddr + (long)dataOff + 35L, this.nextWriteIntentLink);
    }

    @Override
    protected void writeHeader(ByteBuffer pageBuf) {
        super.writeHeader(pageBuf);
        if (this.isWriteIntent()) {
            assert (this.rowId != null);
            pageBuf.putLong(this.rowId.mostSignificantBits());
        } else {
            assert (this.rowId == null);
            pageBuf.putLong(0L);
        }
        PartitionlessLinks.writeToBuffer(pageBuf, this.prevWriteIntentLink);
        PartitionlessLinks.writeToBuffer(pageBuf, this.nextWriteIntentLink);
    }

    @Override
    protected void writeTimestamp(long pageAddr, int dataOff) {
        if (!this.isWriteIntent()) {
            super.writeTimestamp(pageAddr, dataOff);
        }
    }

    @Override
    protected void writeToTimestampSlot(ByteBuffer pageBuf) {
        if (this.isWriteIntent()) {
            assert (this.rowId != null);
            pageBuf.putLong(this.rowId.leastSignificantBits());
        } else {
            super.writeToTimestampSlot(pageBuf);
        }
    }

    @Override
    RowVersionOperations operations() {
        return new WiLinkableRowVersionOperations(this);
    }

    @Override
    public String toString() {
        return S.toString(WiLinkableRowVersion.class, this, super.toString());
    }
}

