/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv;

import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.storage.ReadResult;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.pagememory.mv.AbstractPageMemoryMvPartitionStorage;
import org.apache.ignite3.internal.util.Cursor;
import org.jetbrains.annotations.Nullable;

class ScanAllVersionsCursor
implements Cursor<ReadResult> {
    private final AbstractPageMemoryMvPartitionStorage storage;
    private final HybridTimestamp fromTs;
    private final HybridTimestamp toTs;
    private RowId currentRowId;
    @Nullable
    private List<ReadResult> versions;
    private int currentIndex;

    ScanAllVersionsCursor(RowId fromRowId, HybridTimestamp fromTs, HybridTimestamp toTs, AbstractPageMemoryMvPartitionStorage storage) {
        this.storage = storage;
        this.fromTs = fromTs;
        this.toTs = toTs;
        this.currentRowId = fromRowId;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasNext() {
        return this.storage.busy(() -> {
            if (this.versions == null) {
                this.versions = this.readVersions(this.fromTs);
            }
            if (this.currentIndex > 0) {
                return true;
            }
            do {
                RowId nextRowId;
                if ((nextRowId = this.currentRowId.increment()) == null) {
                    return false;
                }
                RowId currentRowId = this.storage.closestRowId(nextRowId);
                if (currentRowId == null) {
                    return false;
                }
                this.currentRowId = currentRowId;
                this.versions = this.readVersions();
            } while (this.versions.isEmpty());
            return true;
        });
    }

    @Override
    public ReadResult next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        assert (this.versions != null);
        return this.versions.get(--this.currentIndex);
    }

    private List<ReadResult> readVersions(HybridTimestamp fromTs) {
        RowId processingRowId = this.storage.closestRowId(this.currentRowId);
        if (processingRowId == null) {
            return Collections.emptyList();
        }
        this.currentRowId = processingRowId;
        return this.storage.runConsistently(locker -> {
            locker.lock(processingRowId);
            return this.readVersionsUnderLock(result -> {
                HybridTimestamp commitTimestamp = result.commitTimestamp();
                return commitTimestamp == null || commitTimestamp.compareTo(fromTs) >= 0 && commitTimestamp.compareTo(this.toTs) <= 0;
            });
        });
    }

    private List<ReadResult> readVersions() {
        return this.storage.runConsistently(locker -> {
            locker.lock(this.currentRowId);
            return this.readVersionsUnderLock(result -> {
                HybridTimestamp commitTimestamp = result.commitTimestamp();
                return commitTimestamp == null || commitTimestamp.compareTo(this.toTs) <= 0;
            });
        });
    }

    private List<ReadResult> readVersionsUnderLock(Predicate<ReadResult> filter) {
        try (Cursor<ReadResult> cursor = this.storage.scanVersions(this.currentRowId);){
            List<ReadResult> versions = cursor.stream().filter(filter).collect(Collectors.toList());
            this.currentIndex = versions.size();
            List<ReadResult> list = versions;
            return list;
        }
    }
}

