/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv;

import java.util.List;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.pagememory.freelist.FreeList;
import org.apache.ignite3.internal.pagememory.io.DataPageIo;
import org.apache.ignite3.internal.pagememory.io.PageIo;
import org.apache.ignite3.internal.pagememory.tree.IgniteTree;
import org.apache.ignite3.internal.pagememory.util.PageHandler;
import org.apache.ignite3.internal.pagememory.util.PartitionlessLinks;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.pagememory.mv.AbstractPageMemoryMvPartitionStorage;
import org.apache.ignite3.internal.storage.pagememory.mv.FindRowVersion;
import org.apache.ignite3.internal.storage.pagememory.mv.RenewablePartitionStorageState;
import org.apache.ignite3.internal.storage.pagememory.mv.RowVersion;
import org.apache.ignite3.internal.storage.pagememory.mv.VersionChain;
import org.apache.ignite3.internal.storage.pagememory.mv.gc.GcQueue;
import org.apache.ignite3.internal.util.GridUnsafe;
import org.jetbrains.annotations.Nullable;

public class RemoveWriteOnGcInvokeClosure
implements IgniteTree.InvokeClosure<VersionChain> {
    private final RowId rowId;
    private final HybridTimestamp timestamp;
    private final long link;
    private final AbstractPageMemoryMvPartitionStorage storage;
    private final FreeList freeList;
    private final GcQueue gcQueue;
    private IgniteTree.OperationType operationType;
    @Nullable
    private VersionChain newRow;
    private List<RowVersion> toRemove;
    private RowVersion result;
    @Nullable
    private RowVersion toUpdate;
    @Nullable
    private RowVersion toDropFromQueue;

    RemoveWriteOnGcInvokeClosure(RowId rowId, HybridTimestamp timestamp, long link, AbstractPageMemoryMvPartitionStorage storage) {
        this.rowId = rowId;
        this.timestamp = timestamp;
        this.link = link;
        this.storage = storage;
        RenewablePartitionStorageState localState = storage.renewableState;
        this.freeList = localState.freeList();
        this.gcQueue = localState.gcQueue();
    }

    @Override
    public void call(@Nullable VersionChain oldRow) throws IgniteInternalCheckedException {
        RowVersion nextRowVersion;
        assert (oldRow != null) : "rowId=" + this.rowId + ", storage=" + this.storage.createStorageInfo();
        assert (oldRow.hasNextLink()) : oldRow;
        RowVersion rowVersion = this.readRowVersionWithChecks(oldRow);
        this.result = nextRowVersion = this.storage.readRowVersion(rowVersion.nextLink(), AbstractPageMemoryMvPartitionStorage.ALWAYS_LOAD_VALUE);
        assert (this.result.nextLink() == 0L) : "GC queue is broken, nextLink must be null [nextLink=" + rowVersion.nextLink() + ", storage=" + this.storage.createStorageInfo() + "]";
        if (rowVersion.isTombstone()) {
            this.toRemove = List.of(nextRowVersion, rowVersion);
            if (oldRow.headLink() == this.link) {
                this.operationType = IgniteTree.OperationType.REMOVE;
            } else if (oldRow.nextLink() == this.link) {
                this.operationType = IgniteTree.OperationType.PUT;
                this.toUpdate = this.storage.readRowVersion(oldRow.headLink(), AbstractPageMemoryMvPartitionStorage.DONT_LOAD_VALUE);
                this.newRow = oldRow.withNextLink(nextRowVersion.nextLink());
            } else {
                this.operationType = IgniteTree.OperationType.PUT;
                this.newRow = oldRow;
                this.toUpdate = this.storage.findRowVersion(oldRow, FindRowVersion.RowVersionFilter.equalsByNextLink(this.link), false);
            }
            if (this.toUpdate != null && this.toUpdate.isCommitted()) {
                this.toDropFromQueue = this.toUpdate;
            }
        } else {
            this.operationType = IgniteTree.OperationType.PUT;
            this.toRemove = List.of(nextRowVersion);
            this.toUpdate = rowVersion;
            this.newRow = oldRow.headLink() == this.link ? oldRow.withNextLink(nextRowVersion.nextLink()) : oldRow;
        }
    }

    @Override
    @Nullable
    public VersionChain newRow() {
        assert (this.operationType == IgniteTree.OperationType.PUT ^ this.newRow == null) : "newRow=" + this.newRow + ", op=" + this.operationType;
        return this.newRow;
    }

    @Override
    public IgniteTree.OperationType operationType() {
        assert (this.operationType != null);
        return this.operationType;
    }

    @Override
    public void onUpdate() {
        if (this.toUpdate != null) {
            try {
                this.updateNextLink(this.toUpdate.link(), 0L);
            }
            catch (IgniteInternalCheckedException e) {
                throw new StorageException("Error updating the next link: [rowId={}, timestamp={}, rowLink={}, nextLink={}, {}]", (Throwable)e, this.newRow.rowId(), this.timestamp, this.toUpdate.link(), this.result.nextLink(), this.storage.createStorageInfo());
            }
        }
    }

    private void updateNextLink(long link, long nextLink) throws IgniteInternalCheckedException {
        this.freeList.updateDataRow(link, UpdateNextLinkHandler.INSTANCE, nextLink);
    }

    private RowVersion readRowVersionWithChecks(VersionChain versionChain) {
        RowVersion rowVersion = this.storage.readRowVersion(this.link, AbstractPageMemoryMvPartitionStorage.DONT_LOAD_VALUE);
        if (rowVersion == null) {
            throw new StorageException("Could not find row version in the version chain: [rowId={}, timestamp={}, {}]", versionChain.rowId(), this.timestamp, this.storage.createStorageInfo());
        }
        if (!rowVersion.hasNextLink()) {
            throw new StorageException("Missing next row version: [rowId={}, timestamp={}, {}]", versionChain.rowId(), this.timestamp, this.storage.createStorageInfo());
        }
        return rowVersion;
    }

    void afterCompletion() {
        this.toRemove.forEach(this.storage::removeRowVersion);
        if (this.toDropFromQueue != null) {
            boolean removed = this.gcQueue.remove(this.rowId, this.toDropFromQueue.timestamp(), this.toDropFromQueue.link());
            assert (removed) : "Tombstone removal from GC queue should never happen in parallel";
        }
    }

    RowVersion getResult() {
        assert (this.result != null);
        return this.result;
    }

    private static class UpdateNextLinkHandler
    implements PageHandler<Long, Object> {
        private static final UpdateNextLinkHandler INSTANCE = new UpdateNextLinkHandler();

        private UpdateNextLinkHandler() {
        }

        @Override
        public Object run(int groupId, long pageId, long page, long pageAddr, PageIo io, Long nextLink, int itemId) throws IgniteInternalCheckedException {
            DataPageIo dataIo = (DataPageIo)io;
            int payloadOffset = dataIo.getPayloadOffset(pageAddr, itemId, GridUnsafe.pageSize(), 0);
            PartitionlessLinks.writePartitionless(pageAddr + (long)payloadOffset + 9L, nextLink);
            return true;
        }
    }
}

