/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv;

import org.apache.ignite3.internal.pagememory.datapage.PageMemoryTraversal;
import org.apache.ignite3.internal.pagememory.io.DataPagePayload;
import org.apache.ignite3.internal.pagememory.util.PageUtils;
import org.apache.ignite3.internal.pagememory.util.PartitionlessLinks;
import org.apache.ignite3.internal.storage.pagememory.mv.WriteIntentLinks;

class ReadWriteIntentLinks
implements PageMemoryTraversal<Void> {
    private final int partitionId;
    private WriteIntentLinks result;
    private long prevWiLink;
    private long nextWiLink;

    ReadWriteIntentLinks(int partitionId) {
        this.partitionId = partitionId;
    }

    @Override
    public long consumePagePayload(long link, long pageAddr, DataPagePayload payload, Void unused) {
        byte dataType = PageUtils.getByte(pageAddr, payload.offset() + 0);
        assert (dataType == 2 || dataType == 3) : "Unexpected data type: " + dataType;
        this.prevWiLink = PartitionlessLinks.readPartitionless(this.partitionId, pageAddr, payload.offset() + 29);
        this.nextWiLink = PartitionlessLinks.readPartitionless(this.partitionId, pageAddr, payload.offset() + 35);
        return 0L;
    }

    @Override
    public void finish() {
        if (this.result != null) {
            return;
        }
        this.result = new WriteIntentLinks(this.prevWiLink, this.nextWiLink);
    }

    WriteIntentLinks result() {
        return this.result;
    }
}

