/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv;

import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.pagememory.tree.IgniteTree;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.pagememory.mv.AbstractPageMemoryMvPartitionStorage;
import org.apache.ignite3.internal.storage.pagememory.mv.FindRowVersion;
import org.apache.ignite3.internal.storage.pagememory.mv.RowVersion;
import org.apache.ignite3.internal.storage.pagememory.mv.VersionChain;
import org.jetbrains.annotations.Nullable;

class PreloadingForGcInvokeClosure
implements IgniteTree.InvokeClosure<VersionChain> {
    private final RowId rowId;
    private final HybridTimestamp timestamp;
    private final long link;
    private final AbstractPageMemoryMvPartitionStorage storage;

    PreloadingForGcInvokeClosure(RowId rowId, HybridTimestamp timestamp, long link, AbstractPageMemoryMvPartitionStorage storage) {
        this.rowId = rowId;
        this.timestamp = timestamp;
        this.link = link;
        this.storage = storage;
    }

    @Override
    public void call(@Nullable VersionChain oldRow) throws IgniteInternalCheckedException {
        if (oldRow == null || !oldRow.hasNextLink()) {
            return;
        }
        RowVersion rowVersion = this.storage.readRowVersion(this.link, AbstractPageMemoryMvPartitionStorage.DONT_LOAD_VALUE);
        if (rowVersion == null || !rowVersion.hasNextLink()) {
            return;
        }
        this.storage.readRowVersion(rowVersion.nextLink(), AbstractPageMemoryMvPartitionStorage.ALWAYS_LOAD_VALUE);
        if (rowVersion.isTombstone()) {
            if (oldRow.nextLink() == this.link) {
                this.storage.readRowVersion(oldRow.headLink(), AbstractPageMemoryMvPartitionStorage.DONT_LOAD_VALUE);
            } else if (oldRow.headLink() != this.link) {
                this.storage.findRowVersion(oldRow, FindRowVersion.RowVersionFilter.equalsByNextLink(this.link), false);
            }
        }
    }

    @Override
    public IgniteTree.OperationType operationType() {
        return IgniteTree.OperationType.NOOP;
    }

    @Override
    @Nullable
    public VersionChain newRow() {
        throw new StorageException("No updates should occur: [rowId={}, timestamp={}, link={}, storage={}]", this.rowId, this.timestamp, this.link, this.storage.createStorageInfo());
    }

    @Override
    public void onUpdate() {
        throw new StorageException("No updates should occur: [rowId={}, timestamp={}, link={}, storage={}]", this.rowId, this.timestamp, this.link, this.storage.createStorageInfo());
    }
}

