/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv;

import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.pagememory.io.DataPagePayload;
import org.apache.ignite3.internal.pagememory.util.PageUtils;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.storage.pagememory.mv.HybridTimestamps;
import org.apache.ignite3.internal.storage.pagememory.mv.RowVersion;
import org.apache.ignite3.internal.storage.pagememory.mv.RowVersionReader;
import org.jetbrains.annotations.Nullable;

class PlainRowVersionReader
implements RowVersionReader {
    protected final long link;
    protected final int partitionId;
    protected long nextLink;
    @Nullable
    protected HybridTimestamp timestamp;
    private int schemaVersion;
    private int valueSize;
    protected boolean isArchived;

    PlainRowVersionReader(long link, int partitionId) {
        this.link = link;
        this.partitionId = partitionId;
    }

    protected int valueOffset() {
        return 21;
    }

    @Override
    public void readFromPage(long pageAddr, DataPagePayload payload) {
        boolean hasArchivedField;
        this.nextLink = RowVersion.readNextLink(this.partitionId, pageAddr, payload.offset());
        this.timestamp = this.readTimestamp(pageAddr, payload.offset());
        this.schemaVersion = Short.toUnsignedInt(PageUtils.getShort(pageAddr, payload.offset() + 19));
        this.valueSize = PageUtils.getInt(pageAddr, payload.offset() + 15);
        boolean bl = hasArchivedField = this.schemaVersion == 0 && payload.payloadSize() == this.valueOffset() + 1;
        if (hasArchivedField) {
            this.isArchived = PageUtils.getByte(pageAddr, payload.offset() + this.valueOffset()) == 1;
        }
    }

    @Nullable
    protected HybridTimestamp readTimestamp(long pageAddr, int offset) {
        return HybridTimestamps.readTimestamp(pageAddr, offset + 1);
    }

    @Override
    @Nullable
    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    @Override
    public int schemaVersion() {
        return this.schemaVersion;
    }

    @Override
    public int valueSize() {
        return this.valueSize;
    }

    @Override
    public RowVersion createRowVersion(int valueSize, @Nullable BinaryRow value) {
        return new RowVersion(this.partitionId, this.link, this.timestamp, this.nextLink, valueSize, value, this.isArchived);
    }
}

