/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv;

import java.util.UUID;
import java.util.function.Supplier;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.pagememory.tree.IgniteTree;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.storage.AddWriteResult;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.pagememory.mv.AbstractPageMemoryMvPartitionStorage;
import org.apache.ignite3.internal.storage.pagememory.mv.RowVersion;
import org.apache.ignite3.internal.storage.pagememory.mv.VersionChain;
import org.jetbrains.annotations.Nullable;

class AddWriteInvokeClosure
implements IgniteTree.InvokeClosure<VersionChain> {
    protected final RowId rowId;
    @Nullable
    protected final BinaryRow row;
    private final UUID txId;
    private final int commitZoneId;
    private final int commitPartitionId;
    protected final AbstractPageMemoryMvPartitionStorage storage;
    private IgniteTree.OperationType operationType;
    @Nullable
    private VersionChain newRow;
    @Nullable
    private RowVersion toRemove;
    private AddWriteResult addWriteResult;
    protected final boolean isArchivation;

    AddWriteInvokeClosure(RowId rowId, @Nullable BinaryRow row, UUID txId, int commitZoneId, int commitPartitionId, AbstractPageMemoryMvPartitionStorage storage, boolean isArchivation) {
        this.rowId = rowId;
        this.row = row;
        this.txId = txId;
        this.commitZoneId = commitZoneId;
        this.commitPartitionId = commitPartitionId;
        this.storage = storage;
        this.isArchivation = isArchivation;
    }

    @Override
    public final void call(@Nullable VersionChain oldRow) throws IgniteInternalCheckedException {
        RowVersion existingWriteIntent;
        if (oldRow == null) {
            this.operationType = IgniteTree.OperationType.PUT;
            this.addWriteResult = AddWriteResult.success(null);
            RowVersion newVersion = this.insertFirstRowVersion();
            this.newRow = this.createUncommittedVersionChain(newVersion);
            return;
        }
        if (oldRow.isUncommitted() && !this.txId.equals(oldRow.transactionId())) {
            this.addWriteResult = AddWriteResult.txMismatch(oldRow.transactionId(), AddWriteInvokeClosure.latestCommitTimestamp(this.storage, oldRow, this::addWriteInfo));
            this.operationType = IgniteTree.OperationType.NOOP;
            return;
        }
        this.operationType = IgniteTree.OperationType.PUT;
        boolean replacingExistingWriteIntent = oldRow.isUncommitted();
        if (replacingExistingWriteIntent) {
            existingWriteIntent = this.storage.readRowVersion(oldRow.headLink(), AbstractPageMemoryMvPartitionStorage.ALWAYS_LOAD_VALUE);
            this.addWriteResult = AddWriteResult.success(existingWriteIntent.value());
            this.toRemove = existingWriteIntent;
        } else {
            this.addWriteResult = AddWriteResult.success(null);
            existingWriteIntent = null;
        }
        RowVersion newVersion = this.insertAnotherRowVersion(oldRow, existingWriteIntent);
        this.newRow = this.createUncommittedVersionChain(newVersion);
    }

    protected RowVersion insertFirstRowVersion() {
        return this.insertRowVersion(0L);
    }

    protected RowVersion insertAnotherRowVersion(VersionChain oldRow, @Nullable RowVersion existingWriteIntent) {
        return this.insertRowVersion(oldRow.newestCommittedLink());
    }

    private VersionChain createUncommittedVersionChain(RowVersion newVersion) {
        return VersionChain.createUncommitted(this.rowId, this.txId, this.commitZoneId, this.commitPartitionId, newVersion.link(), newVersion.nextLink());
    }

    @Override
    @Nullable
    public VersionChain newRow() {
        assert (this.operationType == IgniteTree.OperationType.PUT == (this.newRow != null)) : this.addWriteInfo() + ", newRow=" + this.newRow + ", op=" + this.operationType;
        return this.newRow;
    }

    @Override
    public IgniteTree.OperationType operationType() {
        assert (this.operationType != null) : this.addWriteInfo();
        return this.operationType;
    }

    private RowVersion insertRowVersion(long nextLink) {
        RowVersion rowVersion = new RowVersion(this.storage.partitionId, nextLink, this.row, this.isArchivation);
        this.storage.insertRowVersion(rowVersion);
        return rowVersion;
    }

    void afterCompletion() {
        if (this.toRemove != null) {
            this.storage.removeRowVersion(this.toRemove);
        }
    }

    @Nullable
    static HybridTimestamp latestCommitTimestamp(AbstractPageMemoryMvPartitionStorage storage, VersionChain chain, Supplier<String> operationInfo) {
        if (!chain.hasCommittedVersions()) {
            return null;
        }
        RowVersion rowVersion = storage.readRowVersion(chain.newestCommittedLink(), AbstractPageMemoryMvPartitionStorage.DONT_LOAD_VALUE);
        assert (rowVersion != null) : operationInfo.get() + ", newestCommittedLink=" + chain.newestCommittedLink();
        return rowVersion.timestamp();
    }

    AddWriteResult result() {
        return this.addWriteResult;
    }

    final String addWriteInfo() {
        return this.storage.addWriteInfo(this.rowId, this.row, this.txId, this.commitZoneId, this.commitPartitionId);
    }
}

