/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.encryption.fileio;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.ignite3.internal.fileio.FileIo;
import org.apache.ignite3.internal.fileio.FileIoDecorator;
import org.apache.ignite3.internal.storage.pagememory.encryption.PersistentPageMemoryEncryptionManager;

public class EncryptedFileIo
extends FileIoDecorator {
    private final int tableId;
    private final PersistentPageMemoryEncryptionManager dataEncryptionManager;
    private final int fullPageSize;
    private final int pagePayloadSize;
    private final byte[] zeroes;

    EncryptedFileIo(FileIo plainFileIo, PersistentPageMemoryEncryptionManager dataEncryptionManager, int tableId, int fullPageSize) {
        super(plainFileIo);
        this.dataEncryptionManager = dataEncryptionManager;
        this.tableId = tableId;
        this.fullPageSize = fullPageSize;
        this.pagePayloadSize = dataEncryptionManager.pagePayloadSize(tableId, fullPageSize);
        this.zeroes = new byte[fullPageSize - this.pagePayloadSize];
    }

    @Override
    public int read(ByteBuffer destBuf, long position) throws IOException {
        assert (destBuf.capacity() == this.fullPageSize);
        ByteBuffer encrypted = ByteBuffer.allocate(this.fullPageSize);
        int res = this.delegate.read(encrypted, position);
        if (res < 0) {
            return res;
        }
        assert (res == this.fullPageSize);
        encrypted.rewind();
        this.dataEncryptionManager.decrypt(encrypted, destBuf, this.tableId);
        destBuf.put(this.zeroes);
        return res;
    }

    @Override
    public int read(ByteBuffer destBuf) throws IOException {
        return this.read(destBuf, this.position());
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        return this.read(ByteBuffer.wrap(buf, off, len), this.position());
    }

    @Override
    public int write(ByteBuffer srcBuf, long position) throws IOException {
        assert (srcBuf.remaining() >= this.fullPageSize) : "The number of elements remaining in buffer should be more or equal to page size [srcBuf.remaining() = " + srcBuf.remaining() + ", pageSize = " + this.fullPageSize + "]";
        ByteBuffer encrypted = ByteBuffer.allocate(this.fullPageSize);
        int srcLimit = srcBuf.limit();
        srcBuf.limit(srcBuf.position() + this.pagePayloadSize);
        this.dataEncryptionManager.encrypt(srcBuf, encrypted, this.tableId);
        srcBuf.limit(srcLimit);
        srcBuf.position(srcBuf.position() + (this.fullPageSize - this.pagePayloadSize));
        encrypted.rewind();
        return this.delegate.write(encrypted, position);
    }

    @Override
    public int write(ByteBuffer srcBuf) throws IOException {
        return this.write(srcBuf, this.position());
    }

    @Override
    public int write(byte[] buf, int off, int len) throws IOException {
        return this.write(ByteBuffer.wrap(buf, off, len), this.position());
    }
}

