/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.encryption;

import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import javax.crypto.Cipher;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.manager.IgniteComponent;
import org.apache.ignite3.internal.pagememory.persistence.PagePayloadSizeAware;
import org.apache.ignite3.internal.vault.VaultManager;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.IgniteException;
import org.gridgain.internal.encryption.DataKeyGenerator;
import org.gridgain.internal.encryption.EncryptionManager;
import org.gridgain.internal.encryption.provider.DataEncryptionKey;
import org.gridgain.internal.encryption.storage.DataEncryptionKeyManager;
import org.gridgain.internal.encryption.storage.DataEncryptionKeyManagerImpl;
import org.gridgain.internal.encryption.storage.VaultKeyStorage;
import org.gridgain.internal.encryption.utils.EncryptionUtils;
import org.jetbrains.annotations.TestOnly;

public class PersistentPageMemoryEncryptionManager
implements PagePayloadSizeAware,
IgniteComponent {
    private static final int INITIAL_KEY_ID = 0;
    private static final Random RANDOM_INSTANCE = new SecureRandom();
    private final ThreadLocal<Cipher> cipher = ThreadLocal.withInitial(() -> {
        try {
            return Cipher.getInstance(DataKeyGenerator.defaultCipherAlgorithm());
        }
        catch (GeneralSecurityException e) {
            throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, (Throwable)e);
        }
    });
    private final EncryptionManager encryptionManager;
    private final DataEncryptionKeyManagerImpl dataEncryptionKeyManager;

    public PersistentPageMemoryEncryptionManager(VaultManager vaultManager, EncryptionManager encryptionManager, FailureProcessor failureProcessor) {
        this.encryptionManager = encryptionManager;
        this.dataEncryptionKeyManager = new DataEncryptionKeyManagerImpl(new VaultKeyStorage(vaultManager, encryptionManager), encryptionManager, failureProcessor);
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        return this.dataEncryptionKeyManager.startAsync(componentContext);
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        return this.dataEncryptionKeyManager.stopAsync(componentContext);
    }

    public void setInitialTableKey(int tableId) {
        this.dataEncryptionKeyManager.createKeyChain(String.valueOf(tableId), DataKeyGenerator.create(0), null);
    }

    public void onTableDestroyed(int tableId) {
        this.dataEncryptionKeyManager.remove(String.valueOf(tableId));
    }

    @Override
    public int pagePayloadSize(int tableId, int fullPageSize) {
        if (!this.encryptionManager.encryptionEnabled() || !this.dataEncryptionKeyManager.keyChainExists(String.valueOf(tableId))) {
            return fullPageSize;
        }
        int encryptedDataSize = fullPageSize - this.pageHeaderSize();
        int encryptionOverhead = EncryptionUtils.encryptedSize(this.cipher.get(), encryptedDataSize) - encryptedDataSize;
        return encryptedDataSize - encryptionOverhead;
    }

    public void encrypt(ByteBuffer srcBuf, ByteBuffer res, int tableId) {
        DataEncryptionKey tblKey = this.dataEncryptionKeyManager.activeKey(String.valueOf(tableId));
        res.putInt(tblKey.id());
        res.position(this.pageHeaderSize());
        EncryptionUtils.encrypt(this.cipher.get(), RANDOM_INSTANCE, srcBuf, res, tblKey.key());
    }

    public void decrypt(ByteBuffer encrypted, ByteBuffer destBuf, int tableId) {
        Cipher localCipher = this.cipher.get();
        int keyId = encrypted.getInt();
        DataEncryptionKey tblKey = this.dataEncryptionKeyManager.getKey(String.valueOf(tableId), keyId);
        encrypted.position(this.pageHeaderSize());
        assert (tblKey != null);
        EncryptionUtils.decrypt(localCipher, encrypted, destBuf, tblKey.key());
    }

    @TestOnly
    public DataEncryptionKeyManager dataEncryptionKeyStorage() {
        return this.dataEncryptionKeyManager;
    }

    private int pageHeaderSize() {
        return EncryptionUtils.roundToBlockSize(this.cipher.get(), 4);
    }
}

