/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.encryption;

import java.nio.ByteBuffer;
import java.nio.file.Path;
import org.apache.ignite3.internal.fileio.FileIoFactory;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.pagememory.persistence.store.EncryptedPageStoreFactory;
import org.apache.ignite3.internal.pagememory.persistence.store.FilePageStore;
import org.apache.ignite3.internal.pagememory.persistence.store.FilePageStoreFactory;
import org.apache.ignite3.internal.storage.pagememory.encryption.PersistentPageMemoryEncryptionManager;
import org.apache.ignite3.internal.storage.pagememory.encryption.fileio.EncryptedFileIoFactory;

public class EncryptedPageStoreFactoryImpl
implements EncryptedPageStoreFactory {
    private final FileIoFactory fileIoFactory;
    private final int pageSize;
    private final PersistentPageMemoryEncryptionManager dataEncryptionManager;

    public EncryptedPageStoreFactoryImpl(FileIoFactory fileIoFactory, int pageSize, PersistentPageMemoryEncryptionManager dataEncryptionManager) {
        this.fileIoFactory = fileIoFactory;
        this.pageSize = pageSize;
        this.dataEncryptionManager = dataEncryptionManager;
    }

    @Override
    public FilePageStore createEncryptedPageStore(int tableId, ByteBuffer headerBuffer, Path filePageStorePath, Path ... deltaFilePaths) throws IgniteInternalCheckedException {
        EncryptedFileIoFactory encryptedFileIoFactory = new EncryptedFileIoFactory(this.dataEncryptionManager, this.fileIoFactory, tableId, this.pageSize);
        return new FilePageStoreFactory(encryptedFileIoFactory, this.pageSize).createPageStore(headerBuffer, filePageStorePath, deltaFilePaths);
    }
}

