/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory;

import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.ignite3.internal.components.LogSyncer;
import org.apache.ignite3.internal.components.LongJvmPauseDetector;
import org.apache.ignite3.internal.configuration.SystemLocalConfiguration;
import org.apache.ignite3.internal.failure.FailureManager;
import org.apache.ignite3.internal.fileio.FileIoFactory;
import org.apache.ignite3.internal.hlc.HybridClock;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.metrics.MetricManager;
import org.apache.ignite3.internal.pagememory.io.PageIoRegistry;
import org.apache.ignite3.internal.pagememory.persistence.store.FilePageStoreManager;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.configurations.StorageConfiguration;
import org.apache.ignite3.internal.storage.engine.MvTableStorage;
import org.apache.ignite3.internal.storage.engine.StorageTableDescriptor;
import org.apache.ignite3.internal.storage.index.StorageIndexDescriptorSupplier;
import org.apache.ignite3.internal.storage.pagememory.EncryptedPageMemoryTableStorage;
import org.apache.ignite3.internal.storage.pagememory.PersistentPageMemoryStorageEngine;
import org.apache.ignite3.internal.storage.pagememory.encryption.EncryptedPageStoreFactoryImpl;
import org.apache.ignite3.internal.storage.pagememory.encryption.PersistentPageMemoryEncryptionManager;
import org.apache.ignite3.internal.vault.VaultManager;
import org.gridgain.internal.encryption.EncryptionManager;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class EncryptionSupportingPageMemoryStorageEngine
extends PersistentPageMemoryStorageEngine {
    private final PersistentPageMemoryEncryptionManager dataEncryptionManager;

    public EncryptionSupportingPageMemoryStorageEngine(String igniteInstanceName, MetricManager metricManager, StorageConfiguration storageConfiguration, @Nullable SystemLocalConfiguration systemLocalConfig, PageIoRegistry ioRegistry, Path storagePath, @Nullable LongJvmPauseDetector longJvmPauseDetector, FailureManager failureManager, VaultManager vaultManager, EncryptionManager encryptionManager, LogSyncer logSyncer, ExecutorService commonExecutorService, HybridClock clock) {
        super(igniteInstanceName, metricManager, storageConfiguration, systemLocalConfig, ioRegistry, storagePath, longJvmPauseDetector, failureManager, logSyncer, commonExecutorService, clock);
        this.dataEncryptionManager = new PersistentPageMemoryEncryptionManager(vaultManager, encryptionManager, failureManager);
    }

    @TestOnly
    public PersistentPageMemoryEncryptionManager dataEncryptionManager() {
        return this.dataEncryptionManager;
    }

    @Override
    public void start() throws StorageException {
        try {
            this.dataEncryptionManager.startAsync(new ComponentContext()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new StorageException("Error starting file page store manager", (Throwable)e);
        }
        super.start();
    }

    @Override
    protected FilePageStoreManager createFilePageStoreManager(String igniteInstanceName, Path storagePath, FileIoFactory fileIoFactory, int pageSize, FailureManager failureManager) {
        return new EncryptedFilePageStoreManager(igniteInstanceName, storagePath, fileIoFactory, pageSize, failureManager, this.dataEncryptionManager);
    }

    @Override
    public MvTableStorage createMvTable(StorageTableDescriptor tableDescriptor, StorageIndexDescriptorSupplier indexDescriptorSupplier) throws StorageException {
        MvTableStorage tableStorage = super.createMvTable(tableDescriptor, indexDescriptorSupplier);
        if (tableDescriptor.isEncryptionEnabled()) {
            int tableId = tableDescriptor.getId();
            this.dataEncryptionManager.setInitialTableKey(tableId);
            return new EncryptedPageMemoryTableStorage(tableStorage, this.dataEncryptionManager);
        }
        return tableStorage;
    }

    private static class EncryptedFilePageStoreManager
    extends FilePageStoreManager {
        private final PersistentPageMemoryEncryptionManager dataEncryptionManager;

        EncryptedFilePageStoreManager(String igniteInstanceName, Path storagePath, FileIoFactory filePageStoreFileIoFactory, int pageSize, FailureManager failureManager, PersistentPageMemoryEncryptionManager dataEncryptionManager) {
            super(igniteInstanceName, storagePath, filePageStoreFileIoFactory, pageSize, new EncryptedPageStoreFactoryImpl(filePageStoreFileIoFactory, pageSize, dataEncryptionManager), failureManager);
            this.dataEncryptionManager = dataEncryptionManager;
        }

        @Override
        public int pagePayloadSize(int tableId, int fullPageSize) {
            return this.dataEncryptionManager.pagePayloadSize(tableId, fullPageSize);
        }
    }
}

