/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.storage.MvPartitionStorage;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.engine.MvPartitionMeta;
import org.apache.ignite3.internal.storage.engine.MvTableStorage;
import org.apache.ignite3.internal.storage.engine.StorageTableDescriptor;
import org.apache.ignite3.internal.storage.index.IndexStorage;
import org.apache.ignite3.internal.storage.index.StorageHashIndexDescriptor;
import org.apache.ignite3.internal.storage.index.StorageSortedIndexDescriptor;
import org.apache.ignite3.internal.storage.pagememory.PersistentPageMemoryDataRegion;
import org.apache.ignite3.internal.storage.pagememory.PersistentPageMemoryTableStorage;
import org.apache.ignite3.internal.storage.pagememory.encryption.PersistentPageMemoryEncryptionManager;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

class EncryptedPageMemoryTableStorage
implements MvTableStorage {
    private final MvTableStorage delegate;
    private final PersistentPageMemoryEncryptionManager dataEncryptionManager;

    EncryptedPageMemoryTableStorage(MvTableStorage delegate, PersistentPageMemoryEncryptionManager dataEncryptionManager) {
        this.delegate = delegate;
        this.dataEncryptionManager = dataEncryptionManager;
    }

    @Override
    public void close() throws Exception {
        this.delegate.close();
    }

    @Override
    public CompletableFuture<MvPartitionStorage> createMvPartition(int partitionId) {
        return this.delegate.createMvPartition(partitionId);
    }

    @Override
    @Nullable
    public MvPartitionStorage getMvPartition(int partitionId) {
        return this.delegate.getMvPartition(partitionId);
    }

    @Override
    public CompletableFuture<Void> destroyPartition(int partitionId) throws StorageException {
        return this.delegate.destroyPartition(partitionId);
    }

    @Override
    public void createSortedIndex(int partitionId, StorageSortedIndexDescriptor indexDescriptor) {
        this.delegate.createSortedIndex(partitionId, indexDescriptor);
    }

    @Override
    public void createHashIndex(int partitionId, StorageHashIndexDescriptor indexDescriptor) {
        this.delegate.createHashIndex(partitionId, indexDescriptor);
    }

    @Override
    public CompletableFuture<Void> destroyIndex(int indexId) {
        return this.delegate.destroyIndex(indexId);
    }

    @Override
    public boolean isVolatile() {
        return this.delegate.isVolatile();
    }

    @Override
    public CompletableFuture<Void> destroy() {
        return this.delegate.destroy().whenComplete((unused, throwable) -> {
            if (throwable == null) {
                this.dataEncryptionManager.onTableDestroyed(this.getTableDescriptor().getId());
            }
        });
    }

    @Override
    public CompletableFuture<Void> startRebalancePartition(int partitionId) {
        return this.delegate.startRebalancePartition(partitionId);
    }

    @Override
    public CompletableFuture<Void> abortRebalancePartition(int partitionId) {
        return this.delegate.abortRebalancePartition(partitionId);
    }

    @Override
    public CompletableFuture<Void> finishRebalancePartition(int partitionId, MvPartitionMeta partitionMeta) {
        return this.delegate.finishRebalancePartition(partitionId, partitionMeta);
    }

    @Override
    public CompletableFuture<Void> clearPartition(int partitionId) {
        return this.delegate.clearPartition(partitionId);
    }

    @Override
    @Nullable
    public IndexStorage getIndex(int partitionId, int indexId) {
        return this.delegate.getIndex(partitionId, indexId);
    }

    @Override
    public StorageTableDescriptor getTableDescriptor() {
        return this.delegate.getTableDescriptor();
    }

    @TestOnly
    public PersistentPageMemoryDataRegion dataRegion() {
        return ((PersistentPageMemoryTableStorage)this.delegate).dataRegion();
    }
}

