/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage;

import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.continuousquery.RowUpdateInfo;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.storage.AbortResult;
import org.apache.ignite3.internal.storage.AddWriteCommittedResult;
import org.apache.ignite3.internal.storage.AddWriteResult;
import org.apache.ignite3.internal.storage.CommitResult;
import org.apache.ignite3.internal.storage.MvPartitionStorage;
import org.apache.ignite3.internal.storage.PartitionTimestampCursor;
import org.apache.ignite3.internal.storage.ReadResult;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.RowMeta;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.ThreadAssertingPartitionTimestampCursor;
import org.apache.ignite3.internal.storage.gc.GcEntry;
import org.apache.ignite3.internal.storage.lease.LeaseInfo;
import org.apache.ignite3.internal.storage.tombstones.Tombstone;
import org.apache.ignite3.internal.util.Cursor;
import org.apache.ignite3.internal.worker.ThreadAssertingCursor;
import org.apache.ignite3.internal.worker.ThreadAssertions;
import org.apache.ignite3.internal.wrapper.Wrapper;
import org.apache.ignite3.table.TableRowEventType;
import org.jetbrains.annotations.Nullable;

public class ThreadAssertingMvPartitionStorage
implements MvPartitionStorage,
Wrapper {
    private final MvPartitionStorage partitionStorage;

    public ThreadAssertingMvPartitionStorage(MvPartitionStorage partitionStorage) {
        this.partitionStorage = partitionStorage;
    }

    @Override
    public <V> V runConsistently(MvPartitionStorage.WriteClosure<V> closure) throws StorageException {
        return this.partitionStorage.runConsistently(closure);
    }

    @Override
    public CompletableFuture<Void> flush(boolean trigger) {
        ThreadAssertions.assertThreadAllowsToWrite();
        return this.partitionStorage.flush(trigger);
    }

    @Override
    public long lastAppliedIndex() {
        return this.partitionStorage.lastAppliedIndex();
    }

    @Override
    public long lastAppliedTerm() {
        return this.partitionStorage.lastAppliedTerm();
    }

    @Override
    public void lastApplied(long lastAppliedIndex, long lastAppliedTerm) throws StorageException {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.partitionStorage.lastApplied(lastAppliedIndex, lastAppliedTerm);
    }

    @Override
    public byte @Nullable [] committedGroupConfiguration() {
        return this.partitionStorage.committedGroupConfiguration();
    }

    @Override
    public void committedGroupConfiguration(byte[] config) {
        this.partitionStorage.committedGroupConfiguration(config);
    }

    @Override
    public ReadResult read(RowId rowId, HybridTimestamp timestamp) throws StorageException {
        ThreadAssertions.assertThreadAllowsToRead();
        return this.partitionStorage.read(rowId, timestamp);
    }

    @Override
    public AddWriteResult addWrite(RowId rowId, @Nullable BinaryRow row, UUID txId, int commitZoneId, int commitPartitionId, boolean isArchivation) throws StorageException {
        ThreadAssertions.assertThreadAllowsToWrite();
        return this.partitionStorage.addWrite(rowId, row, txId, commitZoneId, commitPartitionId, isArchivation);
    }

    @Override
    public AbortResult abortWrite(RowId rowId, UUID txId) throws StorageException {
        ThreadAssertions.assertThreadAllowsToWrite();
        return this.partitionStorage.abortWrite(rowId, txId);
    }

    @Override
    public CommitResult commitWrite(RowId rowId, HybridTimestamp timestamp, UUID txId) throws StorageException {
        ThreadAssertions.assertThreadAllowsToWrite();
        return this.partitionStorage.commitWrite(rowId, timestamp, txId);
    }

    @Override
    public AddWriteCommittedResult addWriteCommitted(RowId rowId, @Nullable BinaryRow row, HybridTimestamp commitTimestamp) throws StorageException {
        ThreadAssertions.assertThreadAllowsToWrite();
        return this.partitionStorage.addWriteCommitted(rowId, row, commitTimestamp);
    }

    @Override
    public Cursor<ReadResult> scanVersions(RowId rowId) throws StorageException {
        ThreadAssertions.assertThreadAllowsToRead();
        return new ThreadAssertingCursor<ReadResult>(this.partitionStorage.scanVersions(rowId));
    }

    @Override
    public PartitionTimestampCursor scan(HybridTimestamp timestamp) throws StorageException {
        ThreadAssertions.assertThreadAllowsToRead();
        return new ThreadAssertingPartitionTimestampCursor(this.partitionStorage.scan(timestamp));
    }

    @Override
    public PartitionTimestampCursor scan(HybridTimestamp from, HybridTimestamp to) throws StorageException {
        ThreadAssertions.assertThreadAllowsToRead();
        return new ThreadAssertingPartitionTimestampCursor(this.partitionStorage.scan(from, to));
    }

    @Override
    public Cursor<Tombstone> scanSnapshotTombstones(HybridTimestamp fromIncluding, HybridTimestamp toIncluding) throws StorageException {
        ThreadAssertions.assertThreadAllowsToRead();
        return new ThreadAssertingCursor<Tombstone>(this.partitionStorage.scanSnapshotTombstones(fromIncluding, toIncluding));
    }

    @Override
    public boolean snapshotTombstonesPreservationSupported() {
        return this.partitionStorage.snapshotTombstonesPreservationSupported();
    }

    @Override
    public void clearSnapshotTombstones(HybridTimestamp upperBoundExcluding) {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.partitionStorage.clearSnapshotTombstones(upperBoundExcluding);
    }

    @Override
    @Nullable
    public RowId closestRowId(RowId lowerBound) throws StorageException {
        ThreadAssertions.assertThreadAllowsToRead();
        return this.partitionStorage.closestRowId(lowerBound);
    }

    @Override
    @Nullable
    public RowId highestRowId() throws StorageException {
        ThreadAssertions.assertThreadAllowsToRead();
        return this.partitionStorage.highestRowId();
    }

    @Override
    public List<RowMeta> rowsStartingWith(RowId lowerBoundInclusive, RowId upperBoundInclusive, int limit) throws StorageException {
        ThreadAssertions.assertThreadAllowsToRead();
        return this.partitionStorage.rowsStartingWith(lowerBoundInclusive, upperBoundInclusive, limit);
    }

    @Override
    public List<GcEntry> peek(HybridTimestamp lowWatermark, int count) {
        ThreadAssertions.assertThreadAllowsToRead();
        return this.partitionStorage.peek(lowWatermark, count);
    }

    @Override
    @Nullable
    public BinaryRow vacuum(GcEntry entry) {
        ThreadAssertions.assertThreadAllowsToWrite();
        return this.partitionStorage.vacuum(entry);
    }

    @Override
    public void updateLease(LeaseInfo leaseInfo) {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.partitionStorage.updateLease(leaseInfo);
    }

    @Override
    @Nullable
    public LeaseInfo leaseInfo() {
        return this.partitionStorage.leaseInfo();
    }

    @Override
    public long estimatedSize() {
        return this.partitionStorage.estimatedSize();
    }

    @Override
    public Cursor<RowId> scanWriteIntents() {
        ThreadAssertions.assertThreadAllowsToRead();
        return this.partitionStorage.scanWriteIntents();
    }

    @Override
    public void close() {
        this.partitionStorage.close();
    }

    @Override
    public <T> T unwrap(Class<T> classToUnwrap) {
        return classToUnwrap.cast(this.partitionStorage);
    }

    @Override
    public Cursor<ReadResult> scanAllVersions(RowId fromRowId, HybridTimestamp fromTs, HybridTimestamp toTs) throws StorageException {
        ThreadAssertions.assertThreadAllowsToRead();
        return new ThreadAssertingCursor<ReadResult>(this.partitionStorage.scanAllVersions(fromRowId, fromTs, toTs));
    }

    @Override
    public List<RowUpdateInfo<BinaryRow>> scanUpdateLog(HybridTimestamp lowerBoundTsIncl, RowId lowerBoundRowIdExcl, HybridTimestamp upperBoundTsIncl, int maxItems, EnumSet<TableRowEventType> eventTypes, boolean skipOldEntries) throws StorageException {
        ThreadAssertions.assertThreadAllowsToRead();
        return this.partitionStorage.scanUpdateLog(lowerBoundTsIncl, lowerBoundRowIdExcl, upperBoundTsIncl, maxItems, eventTypes, skipOldEntries);
    }

    @Override
    public void trimUpdateLog(HybridTimestamp lowWatermark, int maxItems) {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.partitionStorage.trimUpdateLog(lowWatermark, maxItems);
    }

    @Override
    public void discard(RowId rowId) throws StorageException {
        this.partitionStorage.discard(rowId);
    }
}

