/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.util;

import com.google.auto.service.AutoService;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.ignite3.internal.catalog.CatalogValidationException;
import org.apache.ignite3.internal.lang.IgniteExceptionMapper;
import org.apache.ignite3.internal.lang.IgniteExceptionMappersProvider;
import org.apache.ignite3.internal.sql.engine.QueryCancelledException;
import org.apache.ignite3.internal.sql.engine.TxControlInsideExternalTxNotSupportedException;
import org.apache.ignite3.internal.sql.engine.exec.RemoteFragmentExecutionException;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.IgniteException;
import org.apache.ignite3.sql.SqlException;
import org.codehaus.commons.compiler.InternalCompilerException;
import org.gridgain.internal.license.MissingRequiredFeaturesException;

@AutoService(value={IgniteExceptionMappersProvider.class})
public class SqlExceptionMapperProvider
implements IgniteExceptionMappersProvider {
    private static final String NOT_NULL_CONSTRAINT_MESSAGE = "does not allow NULLs";

    @Override
    public Collection<IgniteExceptionMapper<?, ?>> mappers() {
        ArrayList mappers = new ArrayList();
        mappers.add(IgniteExceptionMapper.unchecked(QueryCancelledException.class, err -> new SqlException(err.traceId(), err.code(), err.getMessage(), (Throwable)err)));
        mappers.add(IgniteExceptionMapper.unchecked(RemoteFragmentExecutionException.class, err -> {
            if (err.groupCode() == ErrorGroups.Sql.SQL_ERR_GROUP.groupCode()) {
                return new SqlException(err.traceId(), err.code(), err.getMessage(), (Throwable)err);
            }
            return new IgniteException(err.traceId(), err.code(), err.getMessage(), (Throwable)err);
        }));
        mappers.add(IgniteExceptionMapper.unchecked(CalciteContextException.class, err -> {
            String message = err.getMessage();
            if (message != null && message.contains(NOT_NULL_CONSTRAINT_MESSAGE)) {
                return new SqlException(ErrorGroups.Sql.CONSTRAINT_VIOLATION_ERR, message, (Throwable)err);
            }
            return new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Failed to validate query. " + message, (Throwable)err);
        }));
        mappers.add(IgniteExceptionMapper.unchecked(CatalogValidationException.class, err -> new SqlException(err.traceId(), ErrorGroups.Sql.STMT_VALIDATION_ERR, "Failed to validate query. " + err.getMessage(), (Throwable)err)));
        mappers.add(IgniteExceptionMapper.unchecked(MissingRequiredFeaturesException.class, err -> new SqlException(err.traceId(), err.code(), err.getMessage(), (Throwable)err)));
        mappers.add(IgniteExceptionMapper.unchecked(InternalCompilerException.class, err -> new SqlException(ErrorGroups.Common.INTERNAL_ERR, "Expression compiler error. " + err.getMessage(), (Throwable)err)));
        mappers.add(IgniteExceptionMapper.unchecked(TxControlInsideExternalTxNotSupportedException.class, err -> new SqlException(err.traceId(), err.code(), err.getMessage(), (Throwable)err)));
        return mappers;
    }
}

