/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.util;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.calcite.DataContext;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.RowHandler;
import org.apache.ignite3.internal.sql.engine.exec.exp.IgniteSqlFunctions;
import org.apache.ignite3.internal.sql.engine.util.IgniteMath;
import org.apache.ignite3.internal.sql.engine.util.IgniteSqlDateTimeUtils;

public enum IgniteMethod {
    ROW_BUILDER_ADD_FIELD(RowHandler.RowBuilder.class, "addField", Object.class),
    ROW_HANDLER_GET(RowHandler.class, "get", Integer.TYPE, Object.class),
    CONTEXT_ROW_HANDLER(ExecutionContext.class, "rowHandler", new Class[0]),
    CONTEXT_GET_CORRELATED_VALUE(ExecutionContext.class, "correlatedVariable", Integer.TYPE),
    SUBTRACT_TIMEZONE_OFFSET(IgniteSqlDateTimeUtils.class, "subtractTimeZoneOffset", Long.TYPE, TimeZone.class),
    TO_DATE_EXACT(IgniteSqlFunctions.class, "toDateExact", Integer.TYPE),
    TO_TIMESTAMP_EXACT(IgniteSqlFunctions.class, "toTimestampExact", Long.TYPE),
    TO_TIMESTAMP_LTZ_EXACT(IgniteSqlFunctions.class, "toTimestampLtzExact", Object.class),
    PARSE_INTERVAL_YEAR_MONTH(SqlParserUtil.class, "intervalToMonths", String.class, SqlIntervalQualifier.class),
    PARSE_INTERVAL_DAY_TIME(SqlParserUtil.class, "intervalToMillis", String.class, SqlIntervalQualifier.class),
    BYTESTRING_TO_STRING(IgniteSqlFunctions.class, "toString", ByteString.class),
    STRING_TO_BYTESTRING(IgniteSqlFunctions.class, "toByteString", String.class),
    LEAST2(IgniteSqlFunctions.class, "least2", Object.class, Object.class),
    GREATEST2(IgniteSqlFunctions.class, "greatest2", Object.class, Object.class),
    IS_NOT_DISTINCT_FROM(Objects.class, "equals", Object.class, Object.class),
    RAND_UUID(IgniteSqlFunctions.class, "randUuid", new Class[0]),
    LENGTH(IgniteSqlFunctions.class, "length", Object.class),
    OCTET_LENGTH(IgniteSqlFunctions.class, "octetLength", ByteString.class),
    OCTET_LENGTH2(IgniteSqlFunctions.class, "octetLength", String.class),
    CONSUME_FIRST_ARGUMENT(IgniteSqlFunctions.class, "consumeFirstArgument", Object.class, Object.class),
    SUBSTR(SqlFunctions.class, "substring", String.class, Integer.TYPE, Integer.TYPE),
    ROUND(IgniteSqlFunctions.class, "sround", true),
    TRUNCATE(IgniteSqlFunctions.class, "struncate", true),
    LN(IgniteSqlFunctions.class, "log", true),
    LOG(IgniteSqlFunctions.class, "log", true),
    LOG10(IgniteSqlFunctions.class, "log10", true),
    DECIMAL_DIVIDE(IgniteMath.class, "decimalDivide", BigDecimal.class, BigDecimal.class, Integer.TYPE, Integer.TYPE),
    UNIX_TIMESTAMP_TO_STRING_PRECISION_AWARE(IgniteSqlDateTimeUtils.class, "unixTimestampToString", Long.TYPE, Integer.TYPE),
    UNIX_TIME_TO_STRING_PRECISION_AWARE(IgniteSqlDateTimeUtils.class, "unixTimeToString", Integer.TYPE, Integer.TYPE),
    STRING_TO_TIMESTAMP(IgniteSqlDateTimeUtils.class, "timestampStringToUnixDate", String.class),
    STRING_TO_TIME(IgniteSqlDateTimeUtils.class, "timeStringToUnixDate", String.class),
    CURRENT_DATE(IgniteSqlDateTimeUtils.class, "currentDate", DataContext.class),
    TIME_STRING_TO_TIME(IgniteSqlFunctions.class, "toTime", String.class, String.class),
    DATE_STRING_TO_DATE(IgniteSqlFunctions.class, "toDate", String.class, String.class),
    TIMESTAMP_STRING_TO_TIMESTAMP(IgniteSqlFunctions.class, "toTimestamp", String.class, String.class),
    TIMESTAMP_STRING_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE(IgniteSqlFunctions.class, "toTimestampWithLocalTimeZone", String.class, String.class, TimeZone.class),
    FORMAT_TIME(IgniteSqlFunctions.class, "formatTime", String.class, Integer.class),
    FORMAT_DATE(IgniteSqlFunctions.class, "formatDate", String.class, Integer.class),
    FORMAT_TIMESTAMP(IgniteSqlFunctions.class, "formatTimestamp", String.class, Long.class),
    FORMAT_TIMESTAMP_WITH_LOCAL_TIME_ZONE(IgniteSqlFunctions.class, "formatTimestampWithLocalTimeZone", String.class, Long.class, TimeZone.class),
    ADJUST_TIMESTAMP_MILLIS(IgniteSqlDateTimeUtils.class, "adjustTimestampMillis", Long.class, Integer.TYPE),
    ADJUST_TIME_MILLIS(IgniteSqlDateTimeUtils.class, "adjustTimeMillis", Integer.class, Integer.TYPE),
    FIND_PREFIX(IgniteSqlFunctions.class, "findPrefix", String.class, String.class),
    NEXT_GREATER_PREFIX(IgniteSqlFunctions.class, "nextGreaterPrefix", String.class);

    private final Method method;

    private IgniteMethod(Class<?> clazz, String methodName, Class<?> ... argumentTypes) {
        this.method = Types.lookupMethod(clazz, (String)methodName, (Class[])argumentTypes);
    }

    private IgniteMethod(Class<?> clazz, String methodName, boolean overloadedMethod) {
        this.method = overloadedMethod ? Arrays.stream(clazz.getMethods()).filter(m -> m.getName().equals(methodName)).findFirst().orElseThrow(() -> new IllegalArgumentException(IgniteStringFormatter.format("Public static method {} is not defined", methodName))) : Types.lookupMethod(clazz, (String)methodName, (Class[])new Class[0]);
    }

    public Method method() {
        return this.method;
    }
}

