/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.sql.dcl;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.ignite3.internal.sql.engine.sql.IgniteDdlOperator;
import org.apache.ignite3.internal.sql.engine.sql.dcl.GridgainSqlDcl;
import org.jetbrains.annotations.Nullable;

public class GridgainSqlCreateRole
extends SqlCreate
implements GridgainSqlDcl {
    private final SqlIdentifier name;

    public GridgainSqlCreateRole(SqlParserPos pos, boolean ifNotExists, SqlIdentifier name) {
        super((SqlOperator)new Operator(ifNotExists), pos, false, ifNotExists);
        this.name = name;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableList.of((Object)this.name);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        writer.keyword("ROLE");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
    }

    public SqlIdentifier name() {
        return this.name;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    protected static class Operator
    extends IgniteDdlOperator {
        public Operator(boolean existFlag) {
            super("CREATE ROLE", SqlKind.OTHER_DDL, existFlag);
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new GridgainSqlCreateRole(pos, this.existFlag(), (SqlIdentifier)operands[0]);
        }
    }
}

