/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.SqlWriterConfig;
import org.apache.calcite.sql.dialect.AnsiSqlDialect;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.ignite3.internal.sql.engine.SqlQueryType;
import org.apache.ignite3.internal.sql.engine.exec.fsm.DdlBatchGroup;
import org.apache.ignite3.internal.sql.engine.exec.fsm.DdlBatchingHelper;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlParser;
import org.apache.ignite3.internal.sql.engine.sql.ParsedResult;
import org.apache.ignite3.internal.sql.engine.sql.ParserService;
import org.apache.ignite3.internal.sql.engine.sql.ScriptParseResult;
import org.apache.ignite3.internal.sql.engine.sql.StatementParseResult;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.jetbrains.annotations.Nullable;

public class ParserServiceImpl
implements ParserService {
    private static final SqlWriterConfig NORMALIZED_SQL_WRITER_CONFIG = SqlPrettyWriter.config().withDialect(AnsiSqlDialect.DEFAULT).withAlwaysUseParentheses(false).withSelectListItemsOnSeparateLines(false).withUpdateSetListNewline(false).withIndentation(0);

    @Override
    public ParsedResult parse(String query) {
        StatementParseResult parsedStatement = IgniteSqlParser.parse(query, StatementParseResult.MODE);
        SqlNode parsedTree = parsedStatement.statement();
        return ParserServiceImpl.prepareSingleResult(query, parsedTree, parsedStatement.dynamicParamsCount());
    }

    @Override
    public List<ParsedResult> parseScript(String query) {
        ScriptParseResult parsedStatement = IgniteSqlParser.parse(query, ScriptParseResult.MODE);
        if (parsedStatement.results().size() == 1) {
            StatementParseResult parseResult = parsedStatement.results().get(0);
            return List.of(ParserServiceImpl.prepareSingleResult(query, parseResult.statement(), parseResult.dynamicParamsCount()));
        }
        ArrayList<ParsedResult> results = new ArrayList<ParsedResult>(parsedStatement.results().size());
        List<String> scriptLines = query.lines().collect(Collectors.toList());
        for (StatementParseResult result : parsedStatement.results()) {
            SqlNode parsedTree = result.statement();
            SqlQueryType queryType = Commons.getQueryType(parsedTree);
            String originalQuery = ParserServiceImpl.resembleOriginalQuery(scriptLines, parsedTree.getParserPosition());
            String normalizedQuery = parsedTree.toString();
            assert (queryType != null) : normalizedQuery;
            AtomicBoolean used = new AtomicBoolean();
            results.add(new ParsedResultImpl(queryType, originalQuery, normalizedQuery, result.dynamicParamsCount(), DdlBatchingHelper.extractDdlBatchGroup(parsedTree), queryType == SqlQueryType.TX_CONTROL ? () -> parsedTree : () -> {
                if (!used.compareAndSet(false, true)) {
                    throw new IllegalStateException("Parsed result of script is not reusable.");
                }
                return parsedTree;
            }));
        }
        return results;
    }

    private static String resembleOriginalQuery(List<String> scriptLines, SqlParserPos parserPos) {
        StringBuilder sb = new StringBuilder();
        int startLine = parserPos.getLineNum() - 1;
        int startColumn = parserPos.getColumnNum() - 1;
        int endLine = parserPos.getEndLineNum() - 1;
        int endColumn = parserPos.getEndColumnNum();
        for (int line = startLine; line <= endLine; ++line) {
            String lineString = scriptLines.get(line);
            sb.append(lineString, line == startLine ? startColumn : 0, line == endLine ? Math.min(endColumn + 1, lineString.length()) : lineString.length());
            if (line >= endLine) continue;
            sb.append(System.lineSeparator());
        }
        return sb.toString().trim();
    }

    private static ParsedResult prepareSingleResult(String originalQuery, SqlNode parsedTree, int dynamicParamsCount) {
        SqlQueryType queryType = Commons.getQueryType(parsedTree);
        SqlPrettyWriter w = new SqlPrettyWriter(NORMALIZED_SQL_WRITER_CONFIG);
        parsedTree.unparse((SqlWriter)w, 0, 0);
        String normalizedQuery = w.toString();
        assert (queryType != null) : normalizedQuery;
        AtomicReference<SqlNode> holder = new AtomicReference<SqlNode>(parsedTree);
        return new ParsedResultImpl(queryType, originalQuery, normalizedQuery, dynamicParamsCount, DdlBatchingHelper.extractDdlBatchGroup(parsedTree), () -> {
            SqlNode ast = holder.getAndSet(null);
            if (ast != null) {
                return ast;
            }
            return IgniteSqlParser.parse(originalQuery, StatementParseResult.MODE).statement();
        });
    }

    static class ParsedResultImpl
    implements ParsedResult {
        private final SqlQueryType queryType;
        private final String originalQuery;
        private final String normalizedQuery;
        private final int dynamicParamCount;
        private final Supplier<SqlNode> parsedTreeSupplier;
        @Nullable
        private final DdlBatchGroup ddlBatchGroup;

        private ParsedResultImpl(SqlQueryType queryType, String originalQuery, String normalizedQuery, int dynamicParamCount, @Nullable DdlBatchGroup ddlBatchGroup, Supplier<SqlNode> parsedTreeSupplier) {
            this.queryType = queryType;
            this.originalQuery = originalQuery;
            this.normalizedQuery = normalizedQuery;
            this.dynamicParamCount = dynamicParamCount;
            this.parsedTreeSupplier = parsedTreeSupplier;
            this.ddlBatchGroup = ddlBatchGroup;
            assert (queryType != SqlQueryType.DDL || ddlBatchGroup != null) : "DDL query without batch group";
        }

        @Override
        public SqlQueryType queryType() {
            return this.queryType;
        }

        @Override
        public String originalQuery() {
            return this.originalQuery;
        }

        @Override
        public String normalizedQuery() {
            return this.normalizedQuery;
        }

        @Override
        public int dynamicParamsCount() {
            return this.dynamicParamCount;
        }

        @Override
        @Nullable
        public DdlBatchGroup ddlBatchGroup() {
            return this.ddlBatchGroup;
        }

        @Override
        public SqlNode parsedTree() {
            return this.parsedTreeSupplier.get();
        }
    }
}

