/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.sql;

import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.jetbrains.annotations.Nullable;

public class IgniteSqlExplain
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("EXPLAIN", SqlKind.EXPLAIN){

        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new IgniteSqlExplain(pos, operands[0], operands[1], 0);
        }
    };
    private SqlNode explicandum;
    private SqlNode mode;
    private final int dynamicParameterCount;

    public IgniteSqlExplain(SqlParserPos pos, SqlNode explicandum, SqlNode mode, int dynamicParameterCount) {
        super(pos);
        this.explicandum = explicandum;
        this.mode = mode;
        this.dynamicParameterCount = dynamicParameterCount;
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.explicandum, (Object)this.mode);
    }

    public SqlNode getExplicandum() {
        return this.explicandum;
    }

    public SqlNode getMode() {
        return this.mode;
    }

    public int getDynamicParamCount() {
        return this.dynamicParameterCount;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("EXPLAIN");
        this.mode.unparse(writer, 0, 0);
        writer.keyword("FOR");
        writer.newlineAndIndent();
        this.explicandum.unparse(writer, leftPrec, rightPrec);
    }
}

