/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.sql;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.ignite3.internal.sql.engine.exec.fsm.DdlBatchAware;
import org.apache.ignite3.internal.sql.engine.sql.IgniteAbstractSqlAlterZone;
import org.apache.ignite3.internal.sql.engine.sql.IgniteDdlOperator;
import org.jetbrains.annotations.Nullable;

@DdlBatchAware
public class IgniteSqlAlterZoneRenameTo
extends IgniteAbstractSqlAlterZone {
    private final SqlIdentifier newName;

    public IgniteSqlAlterZoneRenameTo(SqlParserPos pos, SqlIdentifier name, SqlIdentifier newName, boolean ifExists) {
        super(new Operator(ifExists), pos, name);
        this.newName = Objects.requireNonNull(newName, "newName");
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.name, (Object)this.newName);
    }

    public SqlIdentifier newName() {
        return this.newName;
    }

    @Override
    protected void unparseAlterZoneOperation(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("RENAME TO");
        this.newName.unparse(writer, leftPrec, rightPrec);
    }

    protected static class Operator
    extends IgniteDdlOperator {
        protected Operator(boolean existsFlag) {
            super("ALTER ZONE", SqlKind.OTHER_DDL, existsFlag);
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new IgniteSqlAlterZoneRenameTo(pos, (SqlIdentifier)operands[0], (SqlIdentifier)operands[1], this.existFlag());
        }
    }
}

