/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.schema;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.Wrapper;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.ignite3.internal.sql.engine.schema.IgniteDataSource;
import org.apache.ignite3.internal.sql.engine.schema.IgniteSequence;
import org.apache.ignite3.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;

public class IgniteSchema
extends AbstractSchema {
    private final String name;
    private final int catalogVersion;
    private final Map<String, Table> tableByName;
    private final Int2ObjectMap<IgniteDataSource> tableById;
    private final Int2ObjectMap<IgniteSequence> sequenceById;

    public IgniteSchema(String name, int catalogVersion, Collection<? extends IgniteDataSource> tables) {
        this(name, catalogVersion, tables, List.of());
    }

    public IgniteSchema(String name, int catalogVersion, Collection<? extends IgniteDataSource> tables, Collection<? extends IgniteSequence> sequences) {
        this.name = name;
        this.catalogVersion = catalogVersion;
        this.tableById = tables.stream().collect(CollectionUtils.toIntMapCollector(IgniteDataSource::id, Function.identity()));
        this.sequenceById = sequences.stream().collect(CollectionUtils.toIntMapCollector(IgniteSequence::id, Function.identity()));
        this.tableByName = Stream.concat(tables.stream(), sequences.stream()).collect(Collectors.toUnmodifiableMap(w -> {
            IgniteDataSource ds = (IgniteDataSource)((Wrapper)w).unwrap(IgniteDataSource.class);
            if (ds != null) {
                return ds.name();
            }
            IgniteSequence seq = (IgniteSequence)((Wrapper)w).unwrap(IgniteSequence.class);
            if (seq != null) {
                return seq.name();
            }
            throw new IllegalArgumentException("Not a table or sequence: " + w);
        }, Function.identity()));
    }

    public String getName() {
        return this.name;
    }

    public int catalogVersion() {
        return this.catalogVersion;
    }

    protected Map<String, Table> getTableMap() {
        return this.tableByName;
    }

    @Nullable
    IgniteTable tableByIdOpt(int tableId) {
        IgniteDataSource dataSource = (IgniteDataSource)this.tableById.get(tableId);
        if (!(dataSource instanceof IgniteTable)) {
            return null;
        }
        return (IgniteTable)dataSource;
    }

    @Nullable
    IgniteSequence sequenceByIdOpt(int tableId) {
        return (IgniteSequence)this.sequenceById.get(tableId);
    }
}

