/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.rel;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite3.internal.sql.engine.metadata.cost.IgniteCostFactory;
import org.apache.ignite3.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite3.internal.sql.engine.rel.explain.IgniteRelWriter;
import org.apache.ignite3.internal.sql.engine.trait.TraitUtils;

public abstract class IgniteAggregate
extends Aggregate
implements IgniteRel {
    protected IgniteAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        super(cluster, traitSet, List.of(), input, groupSet, groupSets, aggCalls);
    }

    protected IgniteAggregate(RelInput input) {
        super(TraitUtils.changeTraits(input, new RelTrait[]{IgniteConvention.INSTANCE}));
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        Double groupsCnt = mq.getDistinctRowCount(this.getInput(), this.groupSet, null);
        if (groupsCnt != null) {
            return groupsCnt;
        }
        return this.guessDistinctRows(mq, this.groupSet.cardinality());
    }

    public double estimateMemoryForGroup(RelMetadataQuery mq) {
        double mem = (double)this.groupSet.cardinality() * 4.0;
        if (!this.aggCalls.isEmpty()) {
            double grps = this.estimateRowCount(mq);
            for (AggregateCall aggCall : this.aggCalls) {
                if (aggCall.isDistinct()) {
                    ImmutableBitSet aggGroup = ImmutableBitSet.of((Iterable)aggCall.getArgList());
                    double distinctRows = this.guessDistinctRows(mq, aggGroup.cardinality());
                    mem += 5.0 * distinctRows / grps;
                    continue;
                }
                mem += 5.0;
            }
        }
        return mem;
    }

    private double guessDistinctRows(RelMetadataQuery mq, int groupSize) {
        if (groupSize == 0) {
            return 1.0;
        }
        double rowCount = mq.getRowCount(this.getInput());
        return rowCount *= 1.0 - Math.pow(0.8, groupSize);
    }

    protected RelOptCost computeSelfCostHash(RelOptPlanner planner, RelMetadataQuery mq) {
        IgniteCostFactory costFactory = (IgniteCostFactory)planner.getCostFactory();
        double inRows = mq.getRowCount(this.getInput());
        double groups = this.estimateRowCount(mq);
        return costFactory.makeCost(inRows, inRows * 1.0, 0.0, groups * this.estimateMemoryForGroup(mq), 0.0);
    }

    public RelOptCost computeSelfCostSort(RelOptPlanner planner, RelMetadataQuery mq) {
        IgniteCostFactory costFactory = (IgniteCostFactory)planner.getCostFactory();
        double inRows = mq.getRowCount(this.getInput());
        return costFactory.makeCost(inRows, inRows * 1.0, 0.0, this.estimateMemoryForGroup(mq), 0.0);
    }

    @Override
    public IgniteRelWriter explain(IgniteRelWriter writer) {
        RelDataType rowType = this.getInput().getRowType();
        writer.addGroup(this.groupSet, rowType).addAggregation(this.aggCalls, rowType);
        if (this.getGroupType() != Aggregate.Group.SIMPLE) {
            writer.addGroupSets((List<ImmutableBitSet>)this.groupSets, rowType);
        }
        return writer;
    }
}

