/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.prepare;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.sql.engine.InternalSqlRow;
import org.apache.ignite3.internal.sql.engine.InternalSqlRowImpl;
import org.apache.ignite3.internal.sql.engine.SchemaAwareConverter;
import org.apache.ignite3.internal.sql.engine.SqlQueryType;
import org.apache.ignite3.internal.sql.engine.exec.AsyncDataCursor;
import org.apache.ignite3.internal.sql.engine.exec.ExecutablePlan;
import org.apache.ignite3.internal.sql.engine.exec.ExecutableTable;
import org.apache.ignite3.internal.sql.engine.exec.ExecutableTableRegistry;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.RowHandler;
import org.apache.ignite3.internal.sql.engine.exec.ScannableTable;
import org.apache.ignite3.internal.sql.engine.exec.exp.SqlPredicate;
import org.apache.ignite3.internal.sql.engine.exec.exp.SqlProjection;
import org.apache.ignite3.internal.sql.engine.exec.exp.SqlRowProvider;
import org.apache.ignite3.internal.sql.engine.prepare.ExplainablePlan;
import org.apache.ignite3.internal.sql.engine.prepare.ParameterMetadata;
import org.apache.ignite3.internal.sql.engine.prepare.PlanId;
import org.apache.ignite3.internal.sql.engine.prepare.partitionawareness.PartitionAwarenessMetadata;
import org.apache.ignite3.internal.sql.engine.prepare.pruning.PartitionPruningMetadata;
import org.apache.ignite3.internal.sql.engine.rel.IgniteKeyValueGet;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite3.internal.sql.engine.rel.explain.ExplainUtils;
import org.apache.ignite3.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite3.internal.sql.engine.util.Cloner;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.internal.sql.engine.util.IteratorToDataCursorAdapter;
import org.apache.ignite3.internal.sql.engine.util.TypeUtils;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.internal.type.StructNativeType;
import org.apache.ignite3.sql.ResultSetMetadata;
import org.jetbrains.annotations.Nullable;

public class KeyValueGetPlan
implements ExplainablePlan,
ExecutablePlan {
    private static final IgniteLogger LOG = Loggers.forClass(KeyValueGetPlan.class);
    private final PlanId id;
    private final int catalogVersion;
    private final IgniteKeyValueGet lookupNode;
    private final ResultSetMetadata meta;
    private final ParameterMetadata parameterMetadata;
    @Nullable
    private final PartitionAwarenessMetadata partitionAwarenessMetadata;
    @Nullable
    private final PartitionPruningMetadata partitionPruningMetadata;
    private final boolean hasCaches;
    private volatile Performable<?> operation;

    KeyValueGetPlan(PlanId id, int catalogVersion, IgniteKeyValueGet lookupNode, ResultSetMetadata meta, ParameterMetadata parameterMetadata, @Nullable PartitionAwarenessMetadata partitionAwarenessMetadata, @Nullable PartitionPruningMetadata partitionPruningMetadata, boolean hasCaches) {
        this.id = id;
        this.catalogVersion = catalogVersion;
        this.lookupNode = lookupNode;
        this.meta = meta;
        this.parameterMetadata = parameterMetadata;
        this.partitionAwarenessMetadata = partitionAwarenessMetadata;
        this.partitionPruningMetadata = partitionPruningMetadata;
        this.hasCaches = hasCaches;
    }

    @Override
    public PlanId id() {
        return this.id;
    }

    @Override
    public SqlQueryType type() {
        return SqlQueryType.QUERY;
    }

    @Override
    public ResultSetMetadata metadata() {
        return this.meta;
    }

    @Override
    public ParameterMetadata parameterMetadata() {
        return this.parameterMetadata;
    }

    @Override
    @Nullable
    public PartitionAwarenessMetadata partitionAwarenessMetadata() {
        return this.partitionAwarenessMetadata;
    }

    @Override
    @Nullable
    public PartitionPruningMetadata partitionPruningMetadata() {
        return this.partitionPruningMetadata;
    }

    @Override
    public int numSources() {
        return 1;
    }

    private IgniteTable table() {
        IgniteTable table = (IgniteTable)this.lookupNode.getTable().unwrap(IgniteTable.class);
        assert (table != null) : this.lookupNode.getTable();
        return table;
    }

    @Override
    public String explain() {
        IgniteRel clonedRoot = Cloner.clone(this.lookupNode, Commons.cluster());
        return ExplainUtils.toString(clonedRoot);
    }

    private <RowT> Performable<RowT> operation(ExecutionContext<RowT> ctx, ExecutableTableRegistry tableRegistry) {
        Performable operation = (Performable)Commons.cast(this.operation);
        if (operation != null) {
            return operation;
        }
        IgniteTable sqlTable = this.table();
        ExecutableTable executableTable = tableRegistry.getTable(this.catalogVersion, sqlTable.id());
        ScannableTable scannableTable = executableTable.scannableTable();
        ImmutableIntList requiredColumns = this.lookupNode.requiredColumns();
        RexNode filterExpr = this.lookupNode.condition();
        List<RexNode> projectionExpr = this.lookupNode.projects();
        RelDataType rowType = sqlTable.getRowType((RelDataTypeFactory)Commons.typeFactory(), requiredColumns);
        SqlPredicate filter = filterExpr == null ? null : ctx.expressionFactory().predicate(filterExpr, rowType);
        SqlProjection projection = projectionExpr == null ? null : ctx.expressionFactory().project(projectionExpr, rowType);
        RowHandler<RowT> rowHandler = ctx.rowHandler();
        StructNativeType nativeType = TypeUtils.convertStructuredType(rowType);
        RowHandler.RowFactory<RowT> rowFactory = rowHandler.factory(nativeType);
        List<RexNode> keyExpressions = this.lookupNode.keyExpressions();
        SqlRowProvider keySupplier = ctx.expressionFactory().rowSource(keyExpressions);
        RelDataType resultType = this.lookupNode.getRowType();
        SchemaAwareConverter<Object, Object> internalTypeConverter = TypeUtils.resultTypeConverter(resultType);
        operation = filter == null && projection == null ? new SimpleLookupExecution<RowT>(scannableTable, rowHandler, rowFactory, keySupplier, requiredColumns, internalTypeConverter) : new FilterableProjectableLookupExecution<RowT>(scannableTable, rowHandler, rowFactory, keySupplier, filter, projection, requiredColumns, internalTypeConverter);
        this.operation = operation;
        return operation;
    }

    @Override
    public <RowT> AsyncDataCursor<InternalSqlRow> execute(ExecutionContext<RowT> ctx, InternalTransaction tx, ExecutableTableRegistry tableRegistry) {
        Performable<RowT> operation = this.operation(ctx, tableRegistry);
        CompletableFuture result = operation.perform(ctx, tx);
        return new IteratorToDataCursorAdapter<InternalSqlRow>(result, Runnable::run);
    }

    @Override
    public IgniteKeyValueGet getRel() {
        return this.lookupNode;
    }

    @Override
    public boolean hasCaches() {
        return this.hasCaches;
    }

    public int catalogVersion() {
        return this.catalogVersion;
    }

    private static abstract class Performable<RowT> {
        private Performable() {
        }

        abstract CompletableFuture<Iterator<InternalSqlRow>> perform(ExecutionContext<RowT> var1, @Nullable InternalTransaction var2);
    }

    private static class SimpleLookupExecution<RowT>
    extends Performable<RowT> {
        private final ScannableTable table;
        private final RowHandler<RowT> rowHandler;
        private final RowHandler.RowFactory<RowT> tableRowFactory;
        private final SqlRowProvider keySupplier;
        private final int @Nullable [] requiredColumns;
        private final SchemaAwareConverter<Object, Object> internalTypeConverter;

        private SimpleLookupExecution(ScannableTable table, RowHandler<RowT> rowHandler, RowHandler.RowFactory<RowT> tableRowFactory, SqlRowProvider keySupplier, @Nullable ImmutableIntList requiredColumns, SchemaAwareConverter<Object, Object> internalTypeConverter) {
            this.table = table;
            this.rowHandler = rowHandler;
            this.tableRowFactory = tableRowFactory;
            this.keySupplier = keySupplier;
            this.requiredColumns = requiredColumns == null ? null : requiredColumns.toIntArray();
            this.internalTypeConverter = internalTypeConverter;
        }

        @Override
        CompletableFuture<Iterator<InternalSqlRow>> perform(ExecutionContext<RowT> ctx, InternalTransaction tx) {
            RowT key = this.keySupplier.get(ctx);
            return this.table.primaryKeyLookup(ctx, tx, this.tableRowFactory, key, this.requiredColumns).thenApply(row -> {
                if (row == null) {
                    return Collections.emptyIterator();
                }
                return List.of(new InternalSqlRowImpl<Object>(row, this.rowHandler, this.internalTypeConverter)).iterator();
            });
        }
    }

    private static class FilterableProjectableLookupExecution<RowT>
    extends Performable<RowT> {
        private final ScannableTable table;
        private final RowHandler<RowT> rowHandler;
        private final RowHandler.RowFactory<RowT> tableRowFactory;
        private final SqlRowProvider keySupplier;
        @Nullable
        private final SqlPredicate filter;
        @Nullable
        private final SqlProjection projection;
        private final int @Nullable [] requiredColumns;
        private final SchemaAwareConverter<Object, Object> internalTypeConverter;

        private FilterableProjectableLookupExecution(ScannableTable table, RowHandler<RowT> rowHandler, RowHandler.RowFactory<RowT> tableRowFactory, SqlRowProvider keySupplier, @Nullable SqlPredicate filter, @Nullable SqlProjection projection, @Nullable ImmutableIntList requiredColumns, SchemaAwareConverter<Object, Object> internalTypeConverter) {
            this.table = table;
            this.rowHandler = rowHandler;
            this.tableRowFactory = tableRowFactory;
            this.keySupplier = keySupplier;
            this.filter = filter;
            this.projection = projection;
            this.requiredColumns = requiredColumns == null ? null : requiredColumns.toIntArray();
            this.internalTypeConverter = internalTypeConverter;
        }

        @Override
        CompletableFuture<Iterator<InternalSqlRow>> perform(ExecutionContext<RowT> ctx, InternalTransaction tx) {
            Executor executor = task -> ctx.execute(task::run, error -> LOG.error("Unexpected error", (Throwable)error));
            RowT key = this.keySupplier.get(ctx);
            return this.table.primaryKeyLookup(ctx, tx, this.tableRowFactory, key, this.requiredColumns).thenApplyAsync(row -> {
                if (row == null) {
                    return Collections.emptyIterator();
                }
                if (this.filter != null && !this.filter.test(ctx, row)) {
                    return Collections.emptyIterator();
                }
                if (this.projection != null) {
                    row = this.projection.project(ctx, row);
                }
                return List.of(new InternalSqlRowImpl<Object>(row, this.rowHandler, this.internalTypeConverter)).iterator();
            }, executor);
        }
    }
}

