/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.prepare;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlMerge;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.sql2rel.InitializerContext;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ControlFlowException;
import org.apache.calcite.util.Pair;
import org.apache.ignite3.internal.sql.engine.prepare.IgniteSqlValidator;
import org.apache.ignite3.internal.sql.engine.schema.IgniteDataSource;
import org.apache.ignite3.internal.sql.engine.schema.IgniteSequence;
import org.apache.ignite3.internal.sql.engine.sql.fun.GridgainSqlOperatorTable;
import org.apache.ignite3.lang.util.IgniteNameUtils;
import org.jetbrains.annotations.Nullable;

public class IgniteSqlToRelConvertor
extends SqlToRelConverter
implements InitializerContext {
    private final Deque<SqlCall> datasetStack = new ArrayDeque<SqlCall>();
    private RelBuilder relBuilder;

    IgniteSqlToRelConvertor(RelOptTable.ViewExpander viewExpander, @Nullable SqlValidator validator, Prepare.CatalogReader catalogReader, RelOptCluster cluster, SqlRexConvertletTable convertletTable, SqlToRelConverter.Config cfg) {
        super(viewExpander, validator, catalogReader, cluster, convertletTable, cfg);
        this.relBuilder = this.config.getRelBuilderFactory().create(cluster, null);
    }

    protected RelRoot convertQueryRecursive(SqlNode qry, boolean top, @Nullable RelDataType targetRowType) {
        if (qry.getKind() == SqlKind.MERGE) {
            return RelRoot.of((RelNode)this.convertMerge((SqlMerge)qry), (SqlKind)qry.getKind());
        }
        return super.convertQueryRecursive(qry, top, targetRowType);
    }

    protected RexNode convertExtendedExpression(SqlNode expr, SqlToRelConverter.Blackboard bb) {
        if (SqlUtil.isCallTo((SqlNode)expr, (SqlOperator)GridgainSqlOperatorTable.CURRVAL) || SqlUtil.isCallTo((SqlNode)expr, (SqlOperator)GridgainSqlOperatorTable.NEXTVAL)) {
            IgniteSqlValidator validator = (IgniteSqlValidator)bb.getValidator();
            SqlCall call = (SqlCall)expr;
            SqlLiteral op0 = (SqlLiteral)call.operand(0);
            String name = (String)op0.getValueAs(String.class);
            SqlIdentifier id = new SqlIdentifier(IgniteNameUtils.parseName(name), op0.getParserPosition());
            IgniteSequence sequence = validator.getIgniteSequence(id);
            return this.rexBuilder.makeCall(call.getOperator(), new RexNode[]{this.rexBuilder.makeLiteral(name), this.rexBuilder.makeLiteral((Object)sequence.id(), this.typeFactory.createSqlType(SqlTypeName.INTEGER))});
        }
        if (SqlUtil.isCallTo((SqlNode)expr, (SqlOperator)GridgainSqlOperatorTable.SETVAL)) {
            IgniteSqlValidator validator = (IgniteSqlValidator)bb.getValidator();
            SqlCall call = (SqlCall)expr;
            SqlLiteral op0 = (SqlLiteral)call.operand(0);
            SqlLiteral op1 = (SqlLiteral)call.operand(1);
            String name = (String)op0.getValueAs(String.class);
            SqlIdentifier id = new SqlIdentifier(IgniteNameUtils.parseName(name), op0.getParserPosition());
            IgniteSequence sequence = validator.getIgniteSequence(id);
            long value = (Long)op1.getValueAs(Long.class);
            return this.rexBuilder.makeCall(call.getOperator(), new RexNode[]{this.rexBuilder.makeLiteral(name), this.rexBuilder.makeLiteral((Object)sequence.id(), this.typeFactory.createSqlType(SqlTypeName.INTEGER)), this.rexBuilder.makeLiteral((Object)value, this.typeFactory.createSqlType(SqlTypeName.BIGINT))});
        }
        return null;
    }

    protected RelNode convertInsert(SqlInsert call) {
        this.datasetStack.push((SqlCall)call);
        RelNode rel = super.convertInsert(call);
        this.datasetStack.pop();
        return rel;
    }

    public SqlNode validateExpression(RelDataType rowType, SqlNode expr) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public RelNode convertValues(SqlCall values, RelDataType targetRowType) {
        DefaultChecker checker = new DefaultChecker();
        boolean hasDefaults = checker.hasDefaults(values);
        if (hasDefaults) {
            SqlValidatorScope scope = this.validator.getOverScope((SqlNode)values);
            assert (scope != null);
            SqlToRelConverter.Blackboard bb = this.createBlackboard(scope, null, false);
            this.convertValuesImplEx(bb, values, targetRowType);
            return bb.root();
        }
        return super.convertValues(values, targetRowType);
    }

    private void convertValuesImplEx(SqlToRelConverter.Blackboard bb, SqlCall values, RelDataType targetRowType) {
        SqlCall insertOp = this.datasetStack.peek();
        assert (insertOp instanceof SqlInsert);
        assert (values == ((SqlInsert)insertOp).getSource());
        RelOptTable targetTable = this.getTargetTable((SqlNode)insertOp);
        assert (targetTable != null);
        IgniteDataSource ignTable = (IgniteDataSource)targetTable.unwrap(IgniteDataSource.class);
        List tblFields = targetTable.getRowType().getFieldList();
        List targetFields = targetRowType.getFieldNames();
        int[] mapping = new int[targetFields.size()];
        int pos = 0;
        block0: for (String fld : targetFields) {
            int tblPos = 0;
            for (RelDataTypeField tblFld : tblFields) {
                if (tblFld.getName().equals(fld)) {
                    mapping[pos++] = tblPos;
                    continue block0;
                }
                ++tblPos;
            }
        }
        for (SqlNode rowConstructor : values.getOperandList()) {
            SqlCall rowConstructor0 = (SqlCall)rowConstructor;
            ArrayList<Pair> exps = new ArrayList<Pair>(targetFields.size());
            for (pos = 0; pos < targetFields.size(); ++pos) {
                SqlNode operand = (SqlNode)rowConstructor0.getOperandList().get(pos);
                if (operand.getKind() == SqlKind.DEFAULT) {
                    RexNode def = ignTable.descriptor().newColumnDefaultValue(targetTable, mapping[pos], (InitializerContext)bb);
                    exps.add(Pair.of((Object)def, (Object)SqlValidatorUtil.alias((SqlNode)operand, (int)pos)));
                    continue;
                }
                exps.add(Pair.of((Object)bb.convertExpression(operand), (Object)SqlValidatorUtil.alias((SqlNode)operand, (int)pos)));
            }
            RelNode in = null == bb.root ? LogicalValues.createOneRow((RelOptCluster)this.cluster) : bb.root;
            this.relBuilder.push(in).project((Iterable)Pair.left(exps), (Iterable)Pair.right(exps));
        }
        bb.setRoot(this.relBuilder.union(true, values.getOperandList().size()).build(), true);
    }

    private RelNode convertMerge(SqlMerge call) {
        RelOptTable targetTable = this.getTargetTable((SqlNode)call);
        ArrayList<String> targetColumnNameList = new ArrayList<String>();
        RelDataType targetRowType = targetTable.getRowType();
        SqlUpdate updateCall = call.getUpdateCall();
        if (updateCall != null) {
            for (SqlNode targetColumn : updateCall.getTargetColumnList()) {
                SqlIdentifier id = (SqlIdentifier)targetColumn;
                RelDataTypeField field = SqlValidatorUtil.getTargetField((RelDataType)targetRowType, (RelDataTypeFactory)this.typeFactory, (SqlIdentifier)id, (SqlValidatorCatalogReader)this.catalogReader, (RelOptTable)targetTable);
                assert (field != null) : "column " + id.toString() + " not found";
                targetColumnNameList.add(field.getName());
            }
        }
        RelNode mergeSourceRel = this.convertSelect(Objects.requireNonNull(call.getSourceSelect(), () -> "sourceSelect for " + call), false);
        SqlInsert insertCall = call.getInsertCall();
        int numLevel1Exprs = 0;
        ArrayList<RexInputRef> level1InsertExprs = null;
        List level2InsertExprs = null;
        boolean needRepairProject = false;
        if (insertCall != null) {
            RelNode insertRel = this.convertInsert(insertCall);
            RelNode input = insertRel.getInput(0);
            if (input instanceof LogicalProject) {
                level1InsertExprs = ((LogicalProject)input).getProjects();
            } else {
                RelDataType rowType = input.getRowType();
                level1InsertExprs = new ArrayList<RexInputRef>(rowType.getFieldCount());
                int pos = 0;
                for (RelDataTypeField type : rowType.getFieldList()) {
                    level1InsertExprs.add(this.rexBuilder.makeInputRef(type.getType(), pos++));
                }
            }
            numLevel1Exprs = level1InsertExprs.size();
            if (!input.getInputs().isEmpty() && input.getInput(0) instanceof LogicalProject) {
                level2InsertExprs = ((LogicalProject)input.getInput(0)).getProjects();
            }
            needRepairProject = ((LogicalJoin)mergeSourceRel.getInput(0)).getLeft() instanceof LogicalProject && (input.getInputs().isEmpty() || !(input.getInput(0) instanceof LogicalProject) || input.getInput(0).getInputs().isEmpty() || !(input.getInput(0).getInput(0) instanceof LogicalProject));
        }
        LogicalJoin join = (LogicalJoin)mergeSourceRel.getInput(0);
        List<RexNode> projects = new ArrayList<RexNode>();
        for (int level1Idx = 0; level1Idx < numLevel1Exprs; ++level1Idx) {
            Objects.requireNonNull(level1InsertExprs, "level1InsertExprs");
            if (level2InsertExprs != null && level1InsertExprs.get(level1Idx) instanceof RexInputRef) {
                int level2Idx = ((RexInputRef)level1InsertExprs.get(level1Idx)).getIndex();
                projects.add((RexNode)level2InsertExprs.get(level2Idx));
                continue;
            }
            projects.add((RexNode)level1InsertExprs.get(level1Idx));
        }
        if (needRepairProject) {
            projects = this.repairProject(join, projects);
        }
        if (updateCall != null) {
            LogicalProject project = (LogicalProject)mergeSourceRel;
            projects.addAll(project.getProjects());
        } else {
            join = join.copy(join.getTraitSet(), join.getCondition(), join.getLeft(), join.getRight(), JoinRelType.ANTI, false);
        }
        RelBuilder relBuilder = this.config.getRelBuilderFactory().create(this.cluster, null).transform(this.config.getRelBuilderConfigTransform());
        relBuilder.push((RelNode)join).project(projects);
        return LogicalTableModify.create((RelOptTable)targetTable, (Prepare.CatalogReader)this.catalogReader, (RelNode)relBuilder.build(), (TableModify.Operation)TableModify.Operation.MERGE, targetColumnNameList, null, (boolean)false);
    }

    private List<RexNode> repairProject(LogicalJoin join, List<RexNode> actual) {
        if (!(join.getLeft() instanceof LogicalProject)) {
            return actual;
        }
        List original = ((LogicalProject)join.getLeft()).getProjects();
        ArrayList<RexNode> recovered = new ArrayList<RexNode>(actual.size());
        for (RexNode rexNode : actual) {
            int index = original.indexOf(rexNode);
            if (index == -1) {
                recovered.add(rexNode);
                continue;
            }
            recovered.add((RexNode)this.rexBuilder.makeInputRef(rexNode.getType(), index));
        }
        return recovered;
    }

    public RelOptTable getTargetTable(SqlNode call) {
        return super.getTargetTable(call);
    }

    private static class DefaultChecker
    extends SqlShuttle {
        private DefaultChecker() {
        }

        private boolean hasDefaults(SqlCall call) {
            try {
                call.accept((SqlVisitor)this);
                return false;
            }
            catch (ControlFlowException e) {
                return true;
            }
        }

        @Nullable
        public SqlNode visit(SqlCall call) {
            if (call.getKind() == SqlKind.DEFAULT) {
                throw new ControlFlowException();
            }
            return super.visit(call);
        }
    }
}

