/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.message;

import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.apache.ignite3.internal.sql.engine.message.QueryCloseMessage;
import org.apache.ignite3.internal.sql.engine.message.QueryCloseMessageImpl;
import org.apache.ignite3.internal.sql.engine.message.SqlQueryMessagesTypeInfos;

class QueryCloseMessageSerializer
implements MessageSerializer<QueryCloseMessage> {
    public static final QueryCloseMessageSerializer INSTANCE = new QueryCloseMessageSerializer();

    private QueryCloseMessageSerializer() {
    }

    @Override
    public boolean writeMessage(QueryCloseMessage msg, MessageWriter writer) throws MessageMappingException {
        QueryCloseMessageImpl message = (QueryCloseMessageImpl)msg;
        writer.setMessageTypeInfo(SqlQueryMessagesTypeInfos.queryCloseMessage());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)2)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeInt("executionToken", message.executionToken());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeUuid("queryId", message.queryId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

