/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.message;

import java.util.UUID;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.sql.engine.message.ErrorMessage;
import org.apache.ignite3.internal.sql.engine.message.ErrorMessageBuilder;
import org.apache.ignite3.internal.sql.engine.message.SqlQueryMessagesFactory;
import org.apache.ignite3.internal.sql.engine.message.SqlQueryMessagesTypeInfos;

class ErrorMessageDeserializer
implements MessageDeserializer<ErrorMessage> {
    private final ErrorMessageBuilder msg;

    ErrorMessageDeserializer(SqlQueryMessagesFactory messageFactory) {
        this.msg = messageFactory.errorMessage();
    }

    @Override
    public Class<ErrorMessage> klass() {
        return ErrorMessage.class;
    }

    @Override
    public ErrorMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(SqlQueryMessagesTypeInfos.errorMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                int tmp = reader.readInt("code");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.code(tmp);
                reader.incrementState();
            }
            case 1: {
                int tmp = reader.readInt("executionToken");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.executionToken(tmp);
                reader.incrementState();
            }
            case 2: {
                long tmp = reader.readLong("fragmentId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.fragmentId(tmp);
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readString("message");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.message((String)tmp);
                }
                reader.incrementState();
            }
            case 4: {
                Object tmp = reader.readUuid("queryId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.queryId((UUID)tmp);
                }
                reader.incrementState();
            }
            case 5: {
                Object tmp = reader.readUuid("traceId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.traceId((UUID)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ErrorMessage.class);
    }
}

