/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.message;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.sql.engine.message.CancelOperationResponse;
import org.apache.ignite3.internal.sql.engine.message.CancelOperationResponseBuilder;
import org.apache.ignite3.internal.sql.engine.message.CancelOperationResponseSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class CancelOperationResponseImpl
implements CancelOperationResponse,
Cloneable {
    public static final short GROUP_TYPE = 4;
    public static final short TYPE = 7;
    @IgniteToStringInclude
    private Throwable error;
    private byte[] errorByteArray;
    @IgniteToStringInclude
    private final Boolean result;

    private CancelOperationResponseImpl(Throwable error, byte[] errorByteArray, Boolean result) {
        this.error = error;
        this.errorByteArray = errorByteArray;
        this.result = result;
    }

    byte[] errorByteArray() {
        return this.errorByteArray;
    }

    @Override
    public Throwable error() {
        return this.error;
    }

    @Override
    public Boolean result() {
        return this.result;
    }

    public MessageSerializer serializer() {
        return CancelOperationResponseSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 4;
    }

    public String toString() {
        return S.toString(CancelOperationResponseImpl.class, this);
    }

    @Override
    public short messageType() {
        return 7;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CancelOperationResponseImpl otherMessage = (CancelOperationResponseImpl)other;
        return Objects.equals(this.error, otherMessage.error) && Objects.equals(this.result, otherMessage.result);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.error, this.result);
        return result;
    }

    @Override
    public CancelOperationResponseImpl clone() {
        try {
            return (CancelOperationResponseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static CancelOperationResponseBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject errorByteArraymo = marshaller.marshal(this.error);
        usedDescriptors.addAll((IntCollection)errorByteArraymo.usedDescriptorIds());
        this.errorByteArray = errorByteArraymo.bytes();
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.error = (Throwable)marshaller.unmarshal(this.errorByteArray, descriptorsObj);
        this.errorByteArray = null;
    }

    private static class Builder
    implements CancelOperationResponseBuilder {
        private Throwable error;
        private byte[] errorByteArray;
        private Boolean result;

        private Builder() {
        }

        @Override
        public CancelOperationResponseBuilder error(Throwable error) {
            this.error = error;
            return this;
        }

        @Override
        public CancelOperationResponseBuilder errorByteArray(byte[] errorByteArray) {
            this.errorByteArray = errorByteArray;
            return this;
        }

        @Override
        public CancelOperationResponseBuilder result(Boolean result) {
            this.result = result;
            return this;
        }

        @Override
        public Throwable error() {
            return this.error;
        }

        @Override
        public byte[] errorByteArray() {
            return this.errorByteArray;
        }

        @Override
        public Boolean result() {
            return this.result;
        }

        @Override
        public CancelOperationResponse build() {
            return new CancelOperationResponseImpl(this.error, this.errorByteArray, this.result);
        }

        @Override
        public CancelOperationResponse buildDeserialized() {
            return new CancelOperationResponseImpl(this.error, this.errorByteArray, this.result);
        }
    }
}

