/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.rel;

import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.RowHandler;
import org.apache.ignite3.internal.sql.engine.exec.exp.agg.AggregateType;
import org.apache.ignite3.internal.sql.engine.exec.exp.agg.GroupKey;
import org.apache.ignite3.internal.sql.engine.exec.rel.AbstractSetOpNode;

public class MinusNode<RowT>
extends AbstractSetOpNode<RowT> {
    public MinusNode(ExecutionContext<RowT> ctx, int columnCnt, AggregateType type, boolean all, RowHandler.RowFactory<RowT> rowFactory) {
        super(ctx, type, all, rowFactory, new MinusGrouping<RowT>(ctx, rowFactory, columnCnt, type, all));
    }

    private static class MinusGrouping<RowT>
    extends AbstractSetOpNode.Grouping<RowT> {
        private MinusGrouping(ExecutionContext<RowT> ctx, RowHandler.RowFactory<RowT> rowFactory, int columnCnt, AggregateType type, boolean all) {
            super(ctx, rowFactory, columnCnt, type, all, 2);
        }

        @Override
        protected void endOfSet(int setIdx) {
        }

        @Override
        protected void addOnSingle(RowT row, int setIdx) {
            GroupKey key = this.createKey(row);
            if (setIdx == 0) {
                int[] cntrs = this.addGroup(key, 2);
                cntrs[0] = cntrs[0] + 1;
                this.groups.put(key, cntrs);
            } else if (this.all) {
                int[] cntrs = this.getGroup(key);
                if (cntrs != null) {
                    cntrs[1] = cntrs[1] + 1;
                    if (cntrs[1] >= cntrs[0]) {
                        this.groups.remove(key);
                    } else {
                        this.groups.put(key, cntrs);
                    }
                }
            } else {
                this.groups.remove(key);
            }
        }

        @Override
        protected int getCounterFieldsCount() {
            return 2;
        }

        @Override
        protected void addOnMapper(RowT row, int setIdx) {
            GroupKey key = this.createKey(row);
            int[] cntrs = this.addGroup(key, 2);
            int n = setIdx == 0 ? 0 : 1;
            cntrs[n] = cntrs[n] + 1;
            this.groups.put(key, cntrs);
        }

        @Override
        protected boolean affectResult(int[] cntrs) {
            return !this.all || cntrs[0] != cntrs[1];
        }

        @Override
        protected int availableRows(int[] cntrs) {
            assert (cntrs.length == 2);
            if (this.all) {
                return Math.max(cntrs[0] - cntrs[1], 0);
            }
            return cntrs[1] == 0 ? 1 : 0;
        }

        @Override
        protected void updateAvailableRows(int[] cntrs, int availableRows) {
        }

        @Override
        protected void decrementAvailableRows(int[] cntrs, int availableRows) {
            cntrs[0] = cntrs[0] - availableRows;
        }
    }
}

