/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.rel;

import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.RowHandler;
import org.apache.ignite3.internal.sql.engine.exec.exp.agg.AggregateType;
import org.apache.ignite3.internal.sql.engine.exec.exp.agg.GroupKey;
import org.apache.ignite3.internal.sql.engine.exec.rel.AbstractSetOpNode;

public class IntersectNode<RowT>
extends AbstractSetOpNode<RowT> {
    public IntersectNode(ExecutionContext<RowT> ctx, int columnCnt, AggregateType type, boolean all, RowHandler.RowFactory<RowT> rowFactory, int inputsCnt) {
        super(ctx, type, all, rowFactory, new IntersectGrouping<RowT>(ctx, rowFactory, columnCnt, type, all, inputsCnt));
    }

    private static class IntersectGrouping<RowT>
    extends AbstractSetOpNode.Grouping<RowT> {
        private final int inputsCnt;
        private int rowsCnt = 0;

        private IntersectGrouping(ExecutionContext<RowT> ctx, RowHandler.RowFactory<RowT> rowFactory, int columnCnt, AggregateType type, boolean all, int inputsCnt) {
            super(ctx, rowFactory, columnCnt, type, all, inputsCnt);
            this.inputsCnt = inputsCnt;
        }

        @Override
        protected void add(RowT row, int setIdx) {
            ++this.rowsCnt;
            super.add(row, setIdx);
        }

        @Override
        protected void endOfSet(int setIdx) {
            if (this.type == AggregateType.SINGLE && this.rowsCnt == 0) {
                this.groups.clear();
            }
            this.rowsCnt = 0;
        }

        @Override
        protected void addOnSingle(RowT row, int setIdx) {
            GroupKey key = this.createKey(row);
            if (setIdx == 0) {
                int[] cntrs = this.addGroup(key, this.inputsCnt);
                cntrs[0] = cntrs[0] + 1;
                this.groups.put(key, cntrs);
            } else {
                int[] cntrs = this.getGroup(key);
                if (cntrs != null) {
                    if (cntrs[setIdx - 1] == 0) {
                        this.groups.remove(key);
                    } else {
                        int n = setIdx;
                        cntrs[n] = cntrs[n] + 1;
                        this.groups.put(key, cntrs);
                    }
                }
            }
        }

        @Override
        protected int getCounterFieldsCount() {
            return this.inputsCnt;
        }

        @Override
        protected void addOnMapper(RowT row, int setIdx) {
            GroupKey key = this.createKey(row);
            int[] cntrs = this.addGroup(key, this.inputsCnt);
            int n = setIdx;
            cntrs[n] = cntrs[n] + 1;
            this.groups.put(key, cntrs);
        }

        @Override
        protected boolean affectResult(int[] cntrs) {
            return true;
        }

        @Override
        protected int availableRows(int[] cntrs) {
            int cnt = cntrs[0];
            for (int i = 1; i < cntrs.length; ++i) {
                if (cntrs[i] >= cnt) continue;
                cnt = cntrs[i];
            }
            if (this.all) {
                return cnt;
            }
            return cnt == 0 ? 0 : 1;
        }

        @Override
        protected void updateAvailableRows(int[] cntrs, int availableRows) {
            if (this.all) {
                cntrs[0] = availableRows;
            }
        }

        @Override
        protected void decrementAvailableRows(int[] cntrs, int availableRows) {
            cntrs[0] = cntrs[0] - availableRows;
        }
    }
}

