/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.rel;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.BiPredicate;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.RowHandler;
import org.apache.ignite3.internal.sql.engine.exec.exp.SqlJoinProjection;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.RowHashJoinIndex;
import org.apache.ignite3.internal.sql.engine.exec.rel.AbstractRightMaterializedJoinNode;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.internal.sql.engine.util.TypeUtils;
import org.apache.ignite3.internal.type.StructNativeType;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public abstract class HashJoinNode<RowT>
extends AbstractRightMaterializedJoinNode<RowT> {
    private static final BiPredicate<?, ?> ALWAYS_TRUE = (l, r) -> true;
    final RowHashJoinIndex<RowT, RowT> hashStore;
    private final RowHandler.RowFactory<RowT> keyFactory;
    final BiPredicate<RowT, RowT> nonEquiCondition;
    private final int[] leftJoinPositions;
    Iterator<RowT> rightIt = Collections.emptyIterator();

    private HashJoinNode(ExecutionContext<RowT> ctx, JoinInfo joinInfo, RowHandler.RowFactory<RowT> keyFactory, RowHandler.RowFactory<RowT> leftRowFactory, RowHandler.RowFactory<RowT> rightRowFactory, @Nullable BiPredicate<RowT, RowT> nonEquiCondition) {
        super(leftRowFactory, ctx);
        this.leftJoinPositions = joinInfo.leftKeys.toIntArray();
        int[] rightJoinPositions = joinInfo.rightKeys.toIntArray();
        assert (this.leftJoinPositions.length == rightJoinPositions.length);
        assert (this.leftJoinPositions.length == keyFactory.rowSchema().fields().size());
        this.keyFactory = keyFactory;
        this.nonEquiCondition = nonEquiCondition != null ? nonEquiCondition : (BiPredicate)Commons.cast(ALWAYS_TRUE);
        this.hashStore = ctx.storageFactory().hashJoinIndex(rightRowFactory, rightJoinPositions);
    }

    @Override
    protected void closeInternal() {
        super.closeInternal();
        this.rightIt = null;
        IgniteUtils.closeQuiet(this.hashStore::close);
    }

    @Override
    protected void rewindInternal() {
        this.rightIt = Collections.emptyIterator();
        this.hashStore.clear();
        super.rewindInternal();
    }

    public static <RowT> HashJoinNode<RowT> create(ExecutionContext<RowT> ctx, @Nullable SqlJoinProjection projection, RelDataType leftRowType, RelDataType rightRowType, JoinRelType joinType, JoinInfo joinInfo, @Nullable BiPredicate<RowT, RowT> nonEquiCondition) {
        StructNativeType leftRowSchema = TypeUtils.convertStructuredType(leftRowType);
        StructNativeType rightRowSchema = TypeUtils.convertStructuredType(rightRowType);
        RowHandler.RowFactory<RowT> leftRowFactory = ctx.rowHandler().factory(leftRowSchema);
        RowHandler.RowFactory<RowT> rightRowFactory = ctx.rowHandler().factory(rightRowSchema);
        RowHandler.RowFactory<RowT> keyFactory = ctx.rowHandler().factory(TypeUtils.map(leftRowSchema, joinInfo.leftKeys.toIntArray()));
        switch (joinType) {
            case INNER: {
                assert (projection != null);
                return new InnerHashJoin<RowT>(ctx, joinInfo, projection, keyFactory, leftRowFactory, rightRowFactory, nonEquiCondition);
            }
            case LEFT: {
                assert (projection != null);
                return new LeftHashJoin<RowT>(ctx, joinInfo, projection, keyFactory, leftRowFactory, rightRowFactory, nonEquiCondition);
            }
            case RIGHT: {
                assert (projection != null);
                return new RightHashJoin<RowT>(ctx, joinInfo, projection, keyFactory, leftRowFactory, rightRowFactory, nonEquiCondition);
            }
            case FULL: {
                assert (projection != null);
                return new FullOuterHashJoin<RowT>(ctx, joinInfo, projection, keyFactory, leftRowFactory, rightRowFactory, nonEquiCondition);
            }
            case SEMI: {
                assert (projection == null);
                return new SemiHashJoin<RowT>(ctx, joinInfo, keyFactory, leftRowFactory, rightRowFactory, nonEquiCondition);
            }
            case ANTI: {
                assert (projection == null);
                return new AntiHashJoin<RowT>(ctx, joinInfo, keyFactory, leftRowFactory, rightRowFactory, nonEquiCondition);
            }
        }
        throw new IllegalStateException("Join type \"" + joinType + "\" is not supported yet");
    }

    boolean contains(RowT row) {
        RowT key = this.keyFactory.map(row, this.leftJoinPositions);
        return this.hashStore.contains(key);
    }

    Iterator<RowT> lookup(RowT row) {
        RowT key = this.keyFactory.map(row, this.leftJoinPositions);
        return this.hashStore.lookup(key);
    }

    @Override
    protected void pushRight(RowT row) throws Exception {
        assert (this.downstream() != null);
        assert (this.waitingRight > 0);
        --this.waitingRight;
        this.hashStore.add(row);
        if (this.waitingRight == 0) {
            this.waitingRight = this.inBufSize;
            this.rightSource().request(this.waitingRight);
        }
    }

    void getMoreOrEnd() throws Exception {
        if (this.waitingRight == 0) {
            this.waitingRight = this.inBufSize;
            this.rightSource().request(this.waitingRight);
        }
        if (this.waitingLeft == 0 && this.leftInBuf.isEmpty()) {
            this.waitingLeft = this.inBufSize;
            this.leftSource().request(this.waitingLeft);
        }
        if (this.requested > 0 && this.waitingLeft == -1 && this.waitingRight == -1 && this.leftInBuf.isEmpty() && this.left == null && !this.rightIt.hasNext()) {
            this.requested = 0;
            this.hashStore.clear();
            this.downstream().end();
        }
    }

    private static class InnerHashJoin<RowT>
    extends HashJoinNode<RowT> {
        private final SqlJoinProjection outputProjection;

        private InnerHashJoin(ExecutionContext<RowT> ctx, JoinInfo joinInfo, SqlJoinProjection outputProjection, RowHandler.RowFactory<RowT> keyFactory, RowHandler.RowFactory<RowT> leftRowFactory, RowHandler.RowFactory<RowT> rightRowFactory, @Nullable BiPredicate<RowT, RowT> nonEquiCondition) {
            super(ctx, joinInfo, keyFactory, leftRowFactory, rightRowFactory, nonEquiCondition);
            this.outputProjection = outputProjection;
        }

        @Override
        protected void pushLeft(RowT row) throws Exception {
            if (this.waitingRight == -1 && this.hashStore.isEmpty()) {
                --this.waitingLeft;
                if (this.waitingLeft == 0) {
                    this.waitingLeft = -1;
                    this.leftInBuf.clear();
                    this.join();
                }
                return;
            }
            super.pushLeft(row);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void join() throws Exception {
            if (this.waitingRight == -1) {
                this.inLoop = true;
                int processed = 0;
                try {
                    while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty())) {
                        if (!this.rightIt.hasNext()) {
                            this.left = this.leftInBuf.remove();
                            this.acquireRow(this.left);
                            this.rightIt = this.lookup(this.left);
                        }
                        if (this.rightIt.hasNext()) {
                            while (this.requested > 0 && this.rightIt.hasNext()) {
                                if (processed++ > this.inBufSize) {
                                    this.execute(this::join);
                                    return;
                                }
                                Object right = this.rightIt.next();
                                if (!this.nonEquiCondition.test(this.left, right)) continue;
                                --this.requested;
                                Object row = this.outputProjection.project(this.context(), this.left, right);
                                this.acquireRow(row);
                                this.downstream().push(row);
                                this.releaseRow(row);
                            }
                            if (this.rightIt.hasNext()) continue;
                            this.releaseRow(this.left);
                            this.left = null;
                            continue;
                        }
                        this.releaseRow(this.left);
                        this.left = null;
                        if (processed++ <= this.inBufSize) continue;
                        this.execute(this::join);
                        return;
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            this.getMoreOrEnd();
        }
    }

    private static class LeftHashJoin<RowT>
    extends HashJoinNode<RowT> {
        private final RowHandler.RowFactory<RowT> rightRowFactory;
        private final SqlJoinProjection outputProjection;

        private LeftHashJoin(ExecutionContext<RowT> ctx, JoinInfo joinInfo, SqlJoinProjection outputProjection, RowHandler.RowFactory<RowT> keyFactory, RowHandler.RowFactory<RowT> leftRowFactory, RowHandler.RowFactory<RowT> rightRowFactory, @Nullable BiPredicate<RowT, RowT> nonEquiCondition) {
            super(ctx, joinInfo, keyFactory, leftRowFactory, rightRowFactory, nonEquiCondition);
            this.outputProjection = outputProjection;
            this.rightRowFactory = rightRowFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void join() throws Exception {
            if (this.waitingRight == -1) {
                this.inLoop = true;
                int processed = 0;
                try {
                    while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty())) {
                        boolean checkNonEquiCondition;
                        boolean bl = checkNonEquiCondition = this.nonEquiCondition != ALWAYS_TRUE;
                        if (!this.rightIt.hasNext()) {
                            this.left = this.leftInBuf.remove();
                            this.acquireRow(this.left);
                            this.rightIt = this.lookup(this.left);
                            if (!this.rightIt.hasNext()) {
                                this.rightIt = Collections.singletonList(this.rightRowFactory.create()).iterator();
                                checkNonEquiCondition = false;
                            }
                        }
                        if (this.rightIt.hasNext()) {
                            while (this.requested > 0 && this.rightIt.hasNext()) {
                                if (processed++ > this.inBufSize) {
                                    this.execute(this::join);
                                    return;
                                }
                                Object right = this.rightIt.next();
                                if (checkNonEquiCondition && !this.nonEquiCondition.test(this.left, right)) {
                                    right = this.rightRowFactory.create();
                                }
                                --this.requested;
                                Object row = this.outputProjection.project(this.context(), this.left, right);
                                this.acquireRow(row);
                                this.downstream().push(row);
                                this.releaseRow(row);
                            }
                        }
                        if (this.rightIt.hasNext()) continue;
                        this.releaseRow(this.left);
                        this.left = null;
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            this.getMoreOrEnd();
        }
    }

    private static class RightHashJoin<RowT>
    extends HashJoinNode<RowT> {
        private final RowHandler.RowFactory<RowT> leftRowFactory;
        private final SqlJoinProjection outputProjection;
        private boolean drainMaterialization;

        private RightHashJoin(ExecutionContext<RowT> ctx, JoinInfo joinInfo, SqlJoinProjection outputProjection, RowHandler.RowFactory<RowT> keyFactory, RowHandler.RowFactory<RowT> leftRowFactory, RowHandler.RowFactory<RowT> rightRowFactory, @Nullable BiPredicate<RowT, RowT> nonEquiCondition) {
            super(ctx, joinInfo, keyFactory, leftRowFactory, rightRowFactory, nonEquiCondition);
            assert (nonEquiCondition == null) : "Non equi condition is not supported in FULL OUTER join";
            this.outputProjection = outputProjection;
            this.leftRowFactory = leftRowFactory;
        }

        @Override
        protected void rewindInternal() {
            this.drainMaterialization = false;
            super.rewindInternal();
        }

        @Override
        protected void pushLeft(RowT row) throws Exception {
            if (this.waitingRight == -1 && this.hashStore.isEmpty()) {
                --this.waitingLeft;
                if (this.waitingLeft == 0) {
                    this.waitingLeft = -1;
                    this.leftInBuf.clear();
                    this.join();
                }
                return;
            }
            super.pushLeft(row);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void join() throws Exception {
            int processed;
            if (this.waitingRight == -1) {
                this.inLoop = true;
                processed = 0;
                try {
                    while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty())) {
                        if (!this.rightIt.hasNext()) {
                            this.left = this.leftInBuf.remove();
                            this.acquireRow(this.left);
                            this.rightIt = this.lookup(this.left);
                        }
                        if (this.rightIt.hasNext()) {
                            while (this.requested > 0 && this.rightIt.hasNext()) {
                                if (processed++ > this.inBufSize) {
                                    this.execute(this::join);
                                    return;
                                }
                                Object right = this.rightIt.next();
                                --this.requested;
                                Object row = this.outputProjection.project(this.context(), this.left, right);
                                this.acquireRow(row);
                                this.downstream().push(row);
                                this.releaseRow(row);
                            }
                            if (this.rightIt.hasNext()) continue;
                            this.releaseRow(this.left);
                            this.left = null;
                            continue;
                        }
                        this.releaseRow(this.left);
                        this.left = null;
                        if (processed++ <= this.inBufSize) continue;
                        this.execute(this::join);
                        return;
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            if (this.left == null && this.leftInBuf.isEmpty() && this.waitingLeft == -1 && this.waitingRight == -1 && this.requested > 0) {
                this.inLoop = true;
                processed = 0;
                try {
                    if (!this.rightIt.hasNext() && !this.drainMaterialization) {
                        this.drainMaterialization = true;
                        this.rightIt = this.hashStore.untouchedIterator();
                    }
                    RowT emptyLeft = this.leftRowFactory.create();
                    while (this.requested > 0 && this.rightIt.hasNext()) {
                        Object right = this.rightIt.next();
                        Object row = this.outputProjection.project(this.context(), emptyLeft, right);
                        --this.requested;
                        this.acquireRow(row);
                        this.downstream().push(row);
                        this.releaseRow(row);
                        if (processed++ <= this.inBufSize) continue;
                        this.execute(this::join);
                        return;
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            this.getMoreOrEnd();
        }
    }

    private static class FullOuterHashJoin<RowT>
    extends HashJoinNode<RowT> {
        private final RowHandler.RowFactory<RowT> leftRowFactory;
        private final RowHandler.RowFactory<RowT> rightRowFactory;
        private final SqlJoinProjection outputProjection;
        private boolean drainMaterialization;

        private FullOuterHashJoin(ExecutionContext<RowT> ctx, JoinInfo joinInfo, SqlJoinProjection outputProjection, RowHandler.RowFactory<RowT> keyFactory, RowHandler.RowFactory<RowT> leftRowFactory, RowHandler.RowFactory<RowT> rightRowFactory, @Nullable BiPredicate<RowT, RowT> nonEquiCondition) {
            super(ctx, joinInfo, keyFactory, leftRowFactory, rightRowFactory, nonEquiCondition);
            assert (nonEquiCondition == null) : "Non equi condition is not supported in FULL OUTER join";
            this.outputProjection = outputProjection;
            this.leftRowFactory = leftRowFactory;
            this.rightRowFactory = rightRowFactory;
        }

        @Override
        protected void rewindInternal() {
            this.drainMaterialization = false;
            super.rewindInternal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void join() throws Exception {
            int processed;
            if (this.waitingRight == -1) {
                this.inLoop = true;
                processed = 0;
                try {
                    while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty())) {
                        if (!this.rightIt.hasNext()) {
                            this.left = this.leftInBuf.remove();
                            this.acquireRow(this.left);
                            this.rightIt = this.lookup(this.left);
                            if (!this.rightIt.hasNext()) {
                                this.rightIt = Collections.singletonList(this.rightRowFactory.create()).iterator();
                            }
                        }
                        if (this.rightIt.hasNext()) {
                            while (this.requested > 0 && this.rightIt.hasNext()) {
                                if (processed++ > this.inBufSize) {
                                    this.execute(this::join);
                                    return;
                                }
                                Object right = this.rightIt.next();
                                --this.requested;
                                Object row = this.outputProjection.project(this.context(), this.left, right);
                                this.acquireRow(row);
                                this.downstream().push(row);
                                this.releaseRow(row);
                            }
                            if (this.rightIt.hasNext()) continue;
                            this.releaseRow(this.left);
                            this.left = null;
                            continue;
                        }
                        this.releaseRow(this.left);
                        this.left = null;
                        if (processed++ <= this.inBufSize) continue;
                        this.execute(this::join);
                        return;
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            if (this.left == null && this.leftInBuf.isEmpty() && this.waitingLeft == -1 && this.waitingRight == -1 && this.requested > 0) {
                this.inLoop = true;
                processed = 0;
                try {
                    if (!this.rightIt.hasNext() && !this.drainMaterialization) {
                        this.drainMaterialization = true;
                        this.rightIt = this.hashStore.untouchedIterator();
                    }
                    RowT emptyLeft = this.leftRowFactory.create();
                    while (this.requested > 0 && this.rightIt.hasNext()) {
                        Object right = this.rightIt.next();
                        Object row = this.outputProjection.project(this.context(), emptyLeft, right);
                        --this.requested;
                        this.acquireRow(row);
                        this.downstream().push(row);
                        this.releaseRow(row);
                        if (processed++ <= this.inBufSize) continue;
                        this.execute(this::join);
                        return;
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            this.getMoreOrEnd();
        }
    }

    private static class SemiHashJoin<RowT>
    extends HashJoinNode<RowT> {
        private SemiHashJoin(ExecutionContext<RowT> ctx, JoinInfo joinInfo, RowHandler.RowFactory<RowT> keyFactory, RowHandler.RowFactory<RowT> leftRowFactory, RowHandler.RowFactory<RowT> rightRowFactory, @Nullable BiPredicate<RowT, RowT> nonEquiCondition) {
            super(ctx, joinInfo, keyFactory, leftRowFactory, rightRowFactory, nonEquiCondition);
        }

        @Override
        protected void pushLeft(RowT row) throws Exception {
            if (this.waitingRight == -1 && this.hashStore.isEmpty()) {
                --this.waitingLeft;
                if (this.waitingLeft == 0) {
                    this.waitingLeft = -1;
                    this.leftInBuf.clear();
                    this.join();
                }
                return;
            }
            super.pushLeft(row);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void join() throws Exception {
            if (this.waitingRight == -1) {
                this.inLoop = true;
                int processed = 0;
                try {
                    while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty())) {
                        boolean anyMatched = false;
                        if (!this.rightIt.hasNext()) {
                            this.left = this.leftInBuf.remove();
                            this.acquireRow(this.left);
                            if (this.nonEquiCondition == ALWAYS_TRUE) {
                                anyMatched = this.contains(this.left);
                            } else {
                                this.rightIt = this.lookup(this.left);
                            }
                        }
                        while (!anyMatched && this.rightIt.hasNext()) {
                            Object right = this.rightIt.next();
                            if (this.nonEquiCondition.test(this.left, right)) {
                                anyMatched = true;
                                break;
                            }
                            if (processed++ <= this.inBufSize) continue;
                            this.execute(this::join);
                            if (!this.rightIt.hasNext()) {
                                this.releaseRow(this.left);
                                this.left = null;
                            }
                            return;
                        }
                        if (anyMatched) {
                            --this.requested;
                            this.rightIt = Collections.emptyIterator();
                            this.acquireRow(this.left);
                            this.downstream().push(this.left);
                            this.releaseRow(this.left);
                        }
                        if (!this.rightIt.hasNext()) {
                            this.releaseRow(this.left);
                            this.left = null;
                        }
                        if (processed++ <= this.inBufSize) continue;
                        this.execute(this::join);
                        return;
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            this.getMoreOrEnd();
        }
    }

    private static class AntiHashJoin<RowT>
    extends HashJoinNode<RowT> {
        private AntiHashJoin(ExecutionContext<RowT> ctx, JoinInfo joinInfo, RowHandler.RowFactory<RowT> keyFactory, RowHandler.RowFactory<RowT> leftRowFactory, RowHandler.RowFactory<RowT> rightRowFactory, @Nullable BiPredicate<RowT, RowT> nonEquiCondition) {
            super(ctx, joinInfo, keyFactory, leftRowFactory, rightRowFactory, nonEquiCondition);
            assert (nonEquiCondition == null) : "Non equi condition is not supported in ANTI join";
        }

        @Override
        protected void join() throws Exception {
            if (this.waitingRight == -1) {
                this.inLoop = true;
                int processed = 0;
                try {
                    while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty())) {
                        this.left = this.leftInBuf.remove();
                        if (!this.contains(this.left)) {
                            --this.requested;
                            this.acquireRow(this.left);
                            this.downstream().push(this.left);
                            this.releaseRow(this.left);
                        }
                        this.left = null;
                        if (processed++ <= this.inBufSize) continue;
                        this.execute(this::join);
                        return;
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            this.getMoreOrEnd();
        }
    }
}

