/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.memory.structures.offload;

import java.util.Iterator;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.ignite3.internal.sql.engine.exec.memory.MemoryContext;
import org.apache.ignite3.internal.sql.engine.exec.memory.NoOpMemoryContext;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.RowHashJoinIndex;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.offload.OffloadAwareCollection;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.sql.SqlException;
import org.gridgain.lang.GridgainErrorGroups;

@NotThreadSafe
public class OffloadHashJoinIndexAdapter<KeyT, RowT>
implements RowHashJoinIndex<KeyT, RowT>,
OffloadAwareCollection {
    private final Supplier<RowHashJoinIndex<KeyT, RowT>> fileCollectionSupplier;
    private MemoryContext<RowT> memoryContext;
    private RowHashJoinIndex<KeyT, RowT> delegate;
    private final Runnable spillingAction;
    private boolean wasSpilled;
    private boolean wasClosed;

    OffloadHashJoinIndexAdapter(MemoryContext<RowT> memoryContext, RowHashJoinIndex<KeyT, RowT> delegate, Supplier<RowHashJoinIndex<KeyT, RowT>> fileCollectionSupplier, Runnable spillingAction) {
        this.memoryContext = memoryContext;
        this.delegate = delegate;
        this.fileCollectionSupplier = fileCollectionSupplier;
        this.spillingAction = spillingAction;
    }

    @Override
    public int size() {
        this.checkClosed();
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        this.checkClosed();
        return this.delegate.isEmpty();
    }

    @Override
    public void clear() {
        this.checkClosed();
        this.release((RowT)this.delegate);
        this.delegate.clear();
    }

    @Override
    public void add(RowT row) {
        this.checkClosed();
        this.acquire(row);
        this.delegate.add(row);
    }

    @Override
    public Iterator<RowT> iterator() {
        this.checkClosed();
        return this.delegate.iterator();
    }

    @Override
    public boolean contains(KeyT row) {
        this.checkClosed();
        return this.delegate.contains(row);
    }

    @Override
    public Iterator<RowT> lookup(final KeyT row) {
        this.checkClosed();
        return new Iterator<RowT>(){
            KeyT key;
            Iterator<RowT> parent;
            boolean state;
            int item;
            {
                this.key = row;
                this.parent = OffloadHashJoinIndexAdapter.this.delegate.lookup(this.key);
                this.state = OffloadHashJoinIndexAdapter.this.wasSpilled;
            }

            @Override
            public boolean hasNext() {
                this.ensureState();
                return this.parent.hasNext();
            }

            @Override
            public RowT next() {
                this.ensureState();
                Object next = this.parent.next();
                ++this.item;
                if (!this.parent.hasNext()) {
                    this.key = null;
                }
                return next;
            }

            private void ensureState() {
                if (this.state != OffloadHashJoinIndexAdapter.this.wasSpilled) {
                    this.state = OffloadHashJoinIndexAdapter.this.wasSpilled;
                    this.parent = OffloadHashJoinIndexAdapter.this.delegate.lookup(this.key);
                    for (int i = 0; i < this.item; ++i) {
                        this.parent.next();
                    }
                    this.key = null;
                }
            }
        };
    }

    @Override
    public Iterator<RowT> untouchedIterator() {
        this.checkClosed();
        return new Iterator<RowT>(){
            boolean state;
            Iterator<RowT> parent;
            {
                this.state = OffloadHashJoinIndexAdapter.this.wasSpilled;
                this.parent = OffloadHashJoinIndexAdapter.this.delegate.untouchedIterator();
            }

            @Override
            public boolean hasNext() {
                this.ensureState();
                return this.parent.hasNext();
            }

            @Override
            public RowT next() {
                this.ensureState();
                return this.parent.next();
            }

            private void ensureState() {
                if (this.state != OffloadHashJoinIndexAdapter.this.wasSpilled) {
                    this.state = OffloadHashJoinIndexAdapter.this.wasSpilled;
                    this.parent = OffloadHashJoinIndexAdapter.this.delegate.untouchedIterator();
                }
            }
        };
    }

    @Override
    public void onSpillToDisk() {
        if (this.wasSpilled || this.wasClosed) {
            return;
        }
        this.wasSpilled = true;
        RowHashJoinIndex<KeyT, RowT> inMemoryCollection = this.delegate;
        RowHashJoinIndex<KeyT, RowT> fileCollection = this.fileCollectionSupplier.get();
        this.delegate = fileCollection;
        try {
            inMemoryCollection.entryIterator().forEachRemaining(entry -> {
                fileCollection.addEntry((RowHashJoinIndex.IndexEntry<RowT>)entry);
                this.release(entry.row());
            });
        }
        finally {
            this.memoryContext = NoOpMemoryContext.instance();
            IgniteUtils.closeQuiet(inMemoryCollection::close);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.wasClosed) {
            return;
        }
        this.wasClosed = true;
        this.release((RowT)this.delegate);
        this.delegate.close();
    }

    private void checkClosed() {
        if (this.wasClosed) {
            throw new SqlException(GridgainErrorGroups.MemoryQuota.SPILLING_ERR, "Hash join index store has been closed.");
        }
    }

    private void acquire(RowT element) {
        if (!this.memoryContext.tryAcquire(element)) {
            this.spillingAction.run();
        }
    }

    private void release(Iterable<RowT> rows) {
        if (this.wasSpilled) {
            return;
        }
        rows.forEach(this::release);
    }

    private void release(RowT row) {
        this.memoryContext.release(row);
    }
}

