/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.memory.structures.offload;

import java.util.Iterator;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.ignite3.internal.sql.engine.exec.memory.MemoryContext;
import org.apache.ignite3.internal.sql.engine.exec.memory.NoOpMemoryContext;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.RowQueue;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.offload.OffloadAwareCollection;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.sql.SqlException;
import org.gridgain.lang.GridgainErrorGroups;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@NotThreadSafe
class OffloadAwareQueueAdapter<RowT>
implements RowQueue<RowT>,
OffloadAwareCollection {
    private final Supplier<RowQueue<RowT>> fileCollectionSupplier;
    private MemoryContext<RowT> memoryContext;
    private RowQueue<RowT> delegate;
    private final Runnable spillingAction;
    private boolean wasSpilled;
    private boolean wasClosed;

    OffloadAwareQueueAdapter(MemoryContext<RowT> memoryContext, RowQueue<RowT> delegate, Runnable spillingAction, Supplier<RowQueue<RowT>> fileCollectionSupplier) {
        this.memoryContext = memoryContext;
        this.delegate = delegate;
        this.spillingAction = spillingAction;
        this.fileCollectionSupplier = fileCollectionSupplier;
    }

    @Override
    @Nullable
    public RowT peek() {
        this.checkClosed();
        return this.delegate.peek();
    }

    @Override
    @Nullable
    public RowT poll() {
        this.checkClosed();
        RowT element = this.delegate.poll();
        if (element != null) {
            this.memoryContext.release(element);
        }
        return element;
    }

    @Override
    public RowT remove() {
        this.checkClosed();
        RowT element = this.delegate.remove();
        this.release(element);
        return element;
    }

    @Override
    @Nullable
    public RowT enqueue(RowT element) {
        this.checkClosed();
        this.acquire(element);
        RowT row = this.delegate.enqueue(element);
        if (row != null) {
            this.release(row);
        }
        return row;
    }

    @Override
    public void add(RowT element) {
        this.enqueue(element);
    }

    @Override
    public int size() {
        this.checkClosed();
        return this.delegate.size();
    }

    @Override
    public void clear() {
        this.checkClosed();
        this.release((RowT)this.delegate);
        this.delegate.clear();
    }

    @Override
    public boolean isEmpty() {
        this.checkClosed();
        return this.delegate.isEmpty();
    }

    @Override
    @TestOnly
    public Iterator<RowT> iterator() {
        this.checkClosed();
        return this.delegate.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSpillToDisk() {
        if (this.wasSpilled || this.wasClosed) {
            return;
        }
        this.wasSpilled = true;
        RowQueue<RowT> inMemoryCollection = this.delegate;
        RowQueue fileCollection = this.fileCollectionSupplier.get();
        this.delegate = fileCollection;
        try {
            for (Object row : inMemoryCollection) {
                fileCollection.add(row);
                this.release(row);
            }
        }
        catch (Throwable throwable) {
            IgniteUtils.closeQuiet(inMemoryCollection::close);
            throw throwable;
        }
        IgniteUtils.closeQuiet(inMemoryCollection::close);
        this.memoryContext = NoOpMemoryContext.instance();
    }

    @Override
    public void close() throws Exception {
        if (this.wasClosed) {
            return;
        }
        this.wasClosed = true;
        this.release((RowT)this.delegate);
        this.delegate.close();
    }

    private void checkClosed() {
        if (this.wasClosed) {
            throw new SqlException(GridgainErrorGroups.MemoryQuota.SPILLING_ERR, "Queue row store is closed.");
        }
    }

    private void acquire(RowT element) {
        if (!this.memoryContext.tryAcquire(element)) {
            this.spillingAction.run();
        }
    }

    private void release(Iterable<RowT> rows) {
        if (this.wasSpilled) {
            return;
        }
        rows.forEach(this::release);
    }

    private void release(RowT row) {
        this.memoryContext.release(row);
    }
}

