/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.memory.structures.inmemory;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.UnaryOperator;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.ignite3.internal.sql.engine.exec.memory.MemoryContext;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.RowList;
import org.apache.ignite3.sql.SqlException;
import org.gridgain.lang.GridgainErrorGroups;
import org.jetbrains.annotations.Nullable;

@NotThreadSafe
class RowListImpl<RowT>
implements RowList<RowT> {
    private final MemoryContext<RowT> memoryContext;
    @Nullable
    private List<RowT> delegate;

    RowListImpl(MemoryContext<RowT> memoryContext) {
        this.memoryContext = memoryContext;
        this.delegate = new ArrayList<RowT>();
    }

    RowListImpl(MemoryContext<RowT> memoryContext, int initialCapacity) {
        this.memoryContext = memoryContext;
        this.delegate = new ArrayList<RowT>(initialCapacity);
    }

    @Override
    public void add(RowT element) {
        this.checkClosed();
        Objects.requireNonNull(element, "element");
        this.memoryContext.acquire(element);
        this.delegate.add(element);
    }

    @Override
    public int size() {
        this.checkClosed();
        return this.delegate.size();
    }

    @Override
    public void clear() {
        this.checkClosed();
        this.delegate.stream().filter(Objects::nonNull).forEach(this.memoryContext::release);
        this.delegate.clear();
    }

    @Override
    public boolean isEmpty() {
        this.checkClosed();
        return this.delegate.isEmpty();
    }

    @Override
    public RowT get(int index) {
        this.checkClosed();
        return this.delegate.get(index);
    }

    @Override
    public RowT removeLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        RowT row = this.delegate.remove(this.delegate.size() - 1);
        this.memoryContext.release(row);
        return row;
    }

    @Override
    public Iterator<RowT> iterator() {
        this.checkClosed();
        return new Iterator<RowT>(){
            private int cursor;

            @Override
            public boolean hasNext() {
                RowListImpl.this.checkClosed();
                return this.cursor < RowListImpl.this.size();
            }

            @Override
            public RowT next() {
                RowListImpl.this.checkClosed();
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return RowListImpl.this.get(this.cursor++);
            }
        };
    }

    @Override
    public List<RowT> listView(final UnaryOperator<RowT> transformer) {
        this.checkClosed();
        return new AbstractList<RowT>(){

            @Override
            @Nullable
            public RowT get(int index) {
                return transformer.apply(RowListImpl.this.get(index));
            }

            @Override
            public int size() {
                return RowListImpl.this.size();
            }
        };
    }

    @Override
    public void close() {
        if (this.delegate != null) {
            this.delegate.stream().filter(Objects::nonNull).forEach(this.memoryContext::release);
        }
        this.delegate = null;
    }

    private void checkClosed() {
        if (this.delegate == null) {
            throw new SqlException(GridgainErrorGroups.MemoryQuota.SPILLING_ERR, "Row store has been closed.");
        }
    }
}

