/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.memory.structures.file;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.ignite3.internal.fileio.FileIo;
import org.apache.ignite3.internal.fileio.FileIoFactory;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.file.DataDirectory;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.file.ExternalCollectionUtils;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.file.ExternalFileStore;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.sql.SqlException;
import org.gridgain.lang.GridgainErrorGroups;
import org.jetbrains.annotations.Nullable;

public class ExternalFileList
implements Iterable<BinaryTuple>,
AutoCloseable {
    private static final IgniteLogger log = Loggers.forClass(ExternalFileList.class);
    private static final long TOMBSTONE_FLAG = Long.MIN_VALUE;
    private static final int ENTRY_BYTES = 8;
    private final ByteBuffer reusableBuff = ByteBuffer.allocate(8);
    private final ExternalFileStore rowDataStore;
    private FileIo fileIo;
    private Path file;
    private int usedSlots;
    private boolean isClosed = false;

    private static boolean isTombstone(long rowAddress) {
        return (rowAddress & Long.MIN_VALUE) != 0L;
    }

    ExternalFileList(DataDirectory workDir, FileIoFactory fileIoFactory, int columnsCount) {
        this.rowDataStore = new ExternalFileStore(fileIoFactory, workDir, columnsCount);
        this.file = workDir.createFile("listIdx");
        try {
            this.fileIo = fileIoFactory.create(this.file, StandardOpenOption.CREATE_NEW, StandardOpenOption.READ, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            throw new SqlException(GridgainErrorGroups.MemoryQuota.SPILLING_ERR, "Failed to create list index spill file.", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Created spill file " + this.file.getFileName(), new Object[0]);
        }
    }

    @Nullable
    public synchronized BinaryTuple get(int index) {
        this.checkClosed();
        Objects.checkIndex(index, this.usedSlots);
        try {
            long rowAddr = this.readEntryFromIndexFile(index);
            if (ExternalFileList.isTombstone(rowAddr)) {
                return null;
            }
            return this.rowDataStore.read(rowAddr);
        }
        catch (IOException ex) {
            throw ExternalCollectionUtils.accessFailedException(ex);
        }
    }

    @Nullable
    public synchronized BinaryTuple removeLast() {
        this.checkClosed();
        try {
            if (this.size() == 0) {
                throw new NoSuchElementException();
            }
            int index = this.size() - 1;
            long oldRowAddress = this.readEntryFromIndexFile(index);
            --this.usedSlots;
            if (ExternalFileList.isTombstone(oldRowAddress)) {
                return null;
            }
            BinaryTuple oldRow = this.rowDataStore.read(oldRowAddress);
            this.rowDataStore.remove(oldRowAddress);
            return oldRow;
        }
        catch (IOException e) {
            this.close();
            throw ExternalCollectionUtils.accessFailedException(e);
        }
    }

    public synchronized void add(@Nullable BinaryTuple row) {
        this.checkClosed();
        try {
            int index = this.usedSlots;
            this.ensureCapacity(index);
            long newRowAddress = row == null ? -1L : this.rowDataStore.write(row);
            this.writeEntryToIndexFile(index, newRowAddress);
        }
        catch (IOException e) {
            this.close();
            throw ExternalCollectionUtils.accessFailedException(e);
        }
    }

    public synchronized int size() {
        this.checkClosed();
        return this.usedSlots;
    }

    @Override
    public synchronized Iterator<BinaryTuple> iterator() {
        this.checkClosed();
        return new IndexFileIterator(this.usedSlots);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Path idxFile;
        ExternalFileList externalFileList = this;
        synchronized (externalFileList) {
            this.checkClosed();
            idxFile = this.file;
            this.usedSlots = 0;
            this.reusableBuff.clear();
            try {
                this.fileIo.clear();
            }
            catch (IOException e) {
                this.close();
                throw ExternalCollectionUtils.accessFailedException(e);
            }
            this.rowDataStore.reset();
        }
        if (log.isDebugEnabled()) {
            log.debug("External row store file cleaned: " + idxFile.getFileName(), new Object[0]);
        }
    }

    private void ensureCapacity(int index) throws IOException {
        if (this.usedSlots <= index) {
            this.reusableBuff.clear();
            this.reusableBuff.putLong(0L);
            this.reusableBuff.flip();
            this.fileIo.position((long)index * 8L);
            this.fileIo.write(this.reusableBuff);
            this.usedSlots = index + 1;
        }
    }

    private long readEntryFromIndexFile(int slot) throws IOException {
        this.reusableBuff.clear();
        this.fileIo.position((long)slot * 8L);
        this.fileIo.read(this.reusableBuff);
        this.reusableBuff.flip();
        return this.reusableBuff.getLong() - 1L;
    }

    private void writeEntryToIndexFile(int slot, long address) {
        try {
            this.reusableBuff.clear();
            this.reusableBuff.putLong(address + 1L);
            this.reusableBuff.flip();
            this.fileIo.position((long)slot * 8L);
            this.fileIo.writeFully(this.reusableBuff);
        }
        catch (IOException e) {
            IgniteUtils.closeQuiet(this);
            throw ExternalCollectionUtils.accessFailedException(e);
        }
    }

    void checkClosed() {
        if (this.isClosed) {
            throw new SqlException(GridgainErrorGroups.MemoryQuota.SPILLING_ERR, "Row store has been closed.");
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ExternalFileList externalFileList = this;
        synchronized (externalFileList) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        IgniteUtils.closeQuiet(this.fileIo);
        this.rowDataStore.close();
        File indexfile = this.file.toFile();
        if (!indexfile.delete()) {
            log.info("Failed to remove spill file " + indexfile.getName(), new Object[0]);
        } else if (log.isDebugEnabled()) {
            log.debug("Spill file removed " + indexfile.getName(), new Object[0]);
        }
    }

    private class IndexFileIterator
    implements Iterator<BinaryTuple> {
        private final int size;
        private int currentIndex;

        IndexFileIterator(int size) {
            this.size = size;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < this.size;
        }

        @Override
        @Nullable
        public BinaryTuple next() {
            if (this.currentIndex >= this.size) {
                throw new NoSuchElementException();
            }
            return ExternalFileList.this.get(this.currentIndex++);
        }
    }
}

