/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.memory;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite3.configuration.ConfigurationValue;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.metrics.MetricManager;
import org.apache.ignite3.internal.sql.engine.SqlQueryProcessor;
import org.apache.ignite3.internal.sql.engine.exec.LifecycleAware;
import org.apache.ignite3.internal.sql.engine.exec.memory.DisabledMemoryTrackingStrategy;
import org.apache.ignite3.internal.sql.engine.exec.memory.EnabledMemoryTrackingStrategy;
import org.apache.ignite3.internal.sql.engine.exec.memory.MemoryContextFactory;
import org.apache.ignite3.internal.sql.engine.exec.memory.MemoryTrackingStrategy;
import org.apache.ignite3.internal.sql.metrics.SqlMemoryMetricSource;
import org.apache.ignite3.internal.sql.metrics.SqlOffloadingMetricSource;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.StringUtils;
import org.apache.ignite3.sql.SqlException;
import org.gridgain.lang.GridgainErrorGroups;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class SqlMemoryManager<RowT>
implements LifecycleAware {
    private static final IgniteLogger LOG = Loggers.forClass(SqlQueryProcessor.class);
    private final ConfigurationValue<String> nodeQuotaConfig;
    private final ConfigurationValue<String> statementQuotaConfig;
    private final ConfigurationValue<Boolean> offloadingEnabledCfg;
    private final ConfigurationValue<String> offloadingDataDirCfg;
    private final ConfigurationValue<String> offloadingDataLimitCfg;
    private final ConfigurationValue<String> blockSizeCfg;
    private final MetricManager metricManager;
    private volatile long nodeQuota;
    private volatile long statementQuota;
    private volatile boolean offloadingEnabled;
    private final Path workDir;
    private volatile Path offloadingDataDir;
    private volatile long offloadingDataLimit;
    private volatile long blockSize;
    private final AtomicReference<MemoryTrackingStrategy<RowT>> strategyHolder = new AtomicReference(new DisabledMemoryTrackingStrategy());

    public SqlMemoryManager(ConfigurationValue<String> nodeQuotaCfg, ConfigurationValue<String> statementQuotaCfg, MetricManager metricManager, ConfigurationValue<Boolean> offloadingEnabledCfg, Path workDir, ConfigurationValue<String> offloadingDataDirCfg, ConfigurationValue<String> offloadingDataLimitCfg, ConfigurationValue<String> blockSizeCfg) {
        this.nodeQuotaConfig = nodeQuotaCfg;
        this.statementQuotaConfig = statementQuotaCfg;
        this.metricManager = metricManager;
        this.workDir = workDir;
        this.offloadingEnabledCfg = offloadingEnabledCfg;
        this.offloadingDataDirCfg = offloadingDataDirCfg;
        this.offloadingDataLimitCfg = offloadingDataLimitCfg;
        this.blockSizeCfg = blockSizeCfg;
    }

    @Override
    public void start() {
        this.initMemoryTracker();
        SqlMemoryMetricSource memoryMetrics = new SqlMemoryMetricSource(() -> this.nodeQuota, () -> this.statementQuota, this.strategyHolder);
        SqlOffloadingMetricSource offloadingMetrics = new SqlOffloadingMetricSource(() -> this.offloadingDataLimit, this.strategyHolder);
        this.metricManager.registerSource(memoryMetrics);
        this.metricManager.registerSource(offloadingMetrics);
        this.metricManager.enable(memoryMetrics);
        this.metricManager.enable(offloadingMetrics);
        this.logMemoryTrackingConfig();
    }

    private void logMemoryTrackingConfig() {
        MemoryTrackingStrategy<RowT> current = this.strategyHolder.get();
        if (!current.memoryQuotaEnabled()) {
            LOG.info("SQL memory tracking was disabled.", new Object[0]);
        } else {
            this.logEnabledMemoryTrackingConfig(current);
        }
    }

    private void logEnabledMemoryTrackingConfig(MemoryTrackingStrategy<RowT> current) {
        String nodeQuotaStr = SqlMemoryManager.quotaSizeToString(this.nodeQuota);
        String statementQuotaStr = SqlMemoryManager.quotaSizeToString(this.statementQuota);
        String offloadingDataLimitStr = SqlMemoryManager.quotaSizeToString(this.offloadingDataLimit);
        String blockSizeStr = SqlMemoryManager.quotaSizeToString(this.blockSize);
        LOG.info("SQL memory tracking was enabled (node memory quota is {}, memory quota per SQL statement is {}, block size is {}).", nodeQuotaStr, statementQuotaStr, blockSizeStr);
        if (current.offloadingEnabled()) {
            LOG.info("SQL memory offloading was enabled (node data limit is {}, data dir is {}).", offloadingDataLimitStr, this.offloadingDataDir);
        } else {
            LOG.info("SQL memory offloading was disabled.", new Object[0]);
        }
    }

    @Override
    public void stop() throws Exception {
        this.metricManager.unregisterSource("sql.memory");
    }

    @TestOnly
    public long reserved() {
        return this.strategyHolder.get().reserved();
    }

    @TestOnly
    public long nodeMemoryQuota() {
        return this.nodeQuota;
    }

    @TestOnly
    public long statementMemoryQuota() {
        return this.statementQuota;
    }

    @TestOnly
    public long offloadingDataLimit() {
        return this.offloadingDataLimit;
    }

    @TestOnly
    public Path offloadingDataDir() {
        return this.offloadingDataDir;
    }

    @TestOnly
    public boolean memoryQuotasEnabled() {
        return this.strategyHolder.get().memoryQuotaEnabled();
    }

    @TestOnly
    public boolean offloadingEnabled() {
        return this.strategyHolder.get().offloadingEnabled();
    }

    @TestOnly
    public long blockSize() {
        return this.blockSize;
    }

    public MemoryContextFactory<RowT> createFragmentMemoryContextFactory() {
        return this.strategyHolder.get().newFragmentMemoryContextFactory();
    }

    private synchronized void initMemoryTracker() {
        this.setNodeQuota((String)this.nodeQuotaConfig.value());
        this.setStatementQuota((String)this.statementQuotaConfig.value());
        this.setOffloadingEnabled((Boolean)this.offloadingEnabledCfg.value());
        this.setOffloadingDataLimit((String)this.offloadingDataLimitCfg.value());
        this.setOffloadingDataDir((String)this.offloadingDataDirCfg.value());
        this.setBlockSize((String)this.blockSizeCfg.value());
        this.setMemoryTrackingStrategy();
        this.nodeQuotaConfig.listen(ctx -> {
            this.nodeQuotaChanged((String)ctx.newValue());
            return CompletableFutures.nullCompletedFuture();
        });
        this.statementQuotaConfig.listen(ctx -> {
            this.statementQuotaChanged((String)ctx.newValue());
            return CompletableFutures.nullCompletedFuture();
        });
        this.offloadingEnabledCfg.listen(ctx -> {
            this.offloadingEnabledChanged((Boolean)ctx.newValue());
            return CompletableFutures.nullCompletedFuture();
        });
        this.blockSizeCfg.listen(ctx -> {
            this.blockSizeChanged((String)ctx.newValue());
            return CompletableFutures.nullCompletedFuture();
        });
    }

    private boolean setNodeQuota(String newValue) {
        long nodeQuota;
        long oldValue = this.nodeQuota;
        this.nodeQuota = nodeQuota = StringUtils.parseStorageStringSize(newValue, () -> Runtime.getRuntime().maxMemory());
        this.setStatementQuotaValue(nodeQuota, this.statementQuota);
        return oldValue != nodeQuota;
    }

    private boolean setStatementQuota(String newValue) {
        long nodeQuota = this.nodeQuota;
        long oldValue = this.statementQuota;
        long newStatementQuota = StringUtils.parseStorageStringSize(newValue, () -> nodeQuota);
        this.setStatementQuotaValue(nodeQuota, newStatementQuota);
        return oldValue != this.statementQuota;
    }

    private void setStatementQuotaValue(long nodeQuota, long statementQuota) {
        this.statementQuota = nodeQuota > 0L ? Math.min(statementQuota, nodeQuota) : statementQuota;
    }

    private boolean setOffloadingEnabled(boolean newValue) {
        boolean oldValue = this.offloadingEnabled;
        this.offloadingEnabled = newValue;
        return oldValue != this.offloadingEnabled;
    }

    private void setOffloadingDataLimit(String value) {
        if (!this.offloadingEnabled) {
            return;
        }
        if (value == null) {
            return;
        }
        this.offloadingDataLimit = StringUtils.parseStorageStringSize(value, () -> {
            throw new IllegalArgumentException("OffloadingDataLimit does not support percentile values: " + value);
        });
    }

    private void setOffloadingDataDir(String value) {
        if (!this.offloadingEnabled) {
            return;
        }
        Path path = this.workDir.resolve(Paths.get(value, new String[0]));
        if (Files.notExists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new SqlException(GridgainErrorGroups.MemoryQuota.SPILLING_ERR, "Unable to create offloading directory: " + path, (Throwable)e);
            }
        }
        this.offloadingDataDir = path;
    }

    private boolean setBlockSize(String newValue) {
        long newBlockSize;
        long blockSize = this.blockSize;
        this.blockSize = newBlockSize = StringUtils.parseStorageStringSize(newValue, () -> {
            throw new IllegalArgumentException("BlockSize does not support percentile values: " + newValue);
        });
        return blockSize != newBlockSize;
    }

    private void setMemoryTrackingStrategy() {
        MemoryTrackingStrategy strategy = this.nodeQuota == 0L && this.statementQuota == 0L ? new DisabledMemoryTrackingStrategy() : new EnabledMemoryTrackingStrategy(this.nodeQuota, this.statementQuota, this.offloadingEnabled, this.offloadingDataLimit, this.offloadingDataDir, this.blockSize);
        this.strategyHolder.set(strategy);
    }

    private synchronized void nodeQuotaChanged(@Nullable String newValue) {
        if (newValue == null) {
            newValue = "60%";
        }
        if (this.setNodeQuota(newValue)) {
            this.setMemoryTrackingStrategy();
            this.logMemoryTrackingConfig();
        }
    }

    private synchronized void statementQuotaChanged(@Nullable String newValue) {
        if (newValue == null) {
            newValue = "100%";
        }
        if (this.setStatementQuota(newValue)) {
            this.setMemoryTrackingStrategy();
            this.logMemoryTrackingConfig();
        }
    }

    private synchronized void offloadingEnabledChanged(@Nullable Boolean newValue) {
        if (newValue == null) {
            newValue = false;
        }
        if (this.setOffloadingEnabled(newValue)) {
            this.setOffloadingDataLimit((String)this.offloadingDataLimitCfg.value());
            this.setOffloadingDataDir((String)this.offloadingDataDirCfg.value());
            this.setMemoryTrackingStrategy();
            this.logMemoryTrackingConfig();
        }
    }

    private synchronized void blockSizeChanged(@Nullable String newValue) {
        if (newValue == null) {
            newValue = "512k";
        }
        if (this.setBlockSize(newValue)) {
            this.setMemoryTrackingStrategy();
            MemoryTrackingStrategy<RowT> current = this.strategyHolder.get();
            if (current.memoryQuotaEnabled()) {
                this.logEnabledMemoryTrackingConfig(current);
            }
        }
    }

    private static String quotaSizeToString(long value) {
        return value == 0L ? "not limited" : "limited to " + value + " bytes";
    }
}

