/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.memory;

import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionId;
import org.apache.ignite3.internal.sql.engine.exec.InlineReferenceCounter;
import org.apache.ignite3.internal.sql.engine.exec.SqlRowHandler;
import org.apache.ignite3.internal.sql.engine.exec.memory.MemoryContext;
import org.apache.ignite3.internal.sql.engine.exec.memory.MemoryContextFactory;
import org.apache.ignite3.internal.sql.engine.exec.memory.MemoryContextImpl;
import org.apache.ignite3.internal.sql.engine.exec.memory.MemoryContextProvider;
import org.apache.ignite3.internal.sql.engine.exec.memory.MemoryTracker;
import org.apache.ignite3.internal.sql.engine.exec.memory.MemoryTrackerImpl;
import org.apache.ignite3.internal.sql.engine.exec.memory.MemoryTrackingStrategy;
import org.apache.ignite3.internal.sql.engine.exec.memory.NoOpMemoryTracker;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.RowStorageFactory;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.file.DataDirectory;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.file.DelegatedFileIoTrackerImpl;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.file.FileIoTracker;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.file.FileIoTrackerImpl;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.inmemory.RowStorageFactoryImpl;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.offload.OffloadAwareStorageFactoryImpl;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.offload.QueryFragmentOffloadingEvent;
import org.gridgain.lang.GridgainErrorGroups;

class EnabledMemoryTrackingStrategy<RowT>
extends MemoryTrackingStrategy<RowT> {
    private static final String NODE_QUOTA_NAME = "Node quota";
    private static final String STATEMENT_QUOTA_NAME = "Statement quota";
    private static final String OFFLOADING_DATA_LIMIT = "Offloading data limit";
    private final long statementQuota;
    private final MemoryTracker rootMemoryTracker;
    private final boolean offloadingEnabled;
    private final MemoryTracker rootFileDataTracker;
    private final long offloadingDataLimit;
    private final FileIoTracker rootFileTracker;
    private final Path offloadingDataDir;
    private final Set<ExecutionId> activeOffloadedQueries = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicLong offloadedQueriesCount = new AtomicLong();
    private final long blockSize;

    EnabledMemoryTrackingStrategy(long nodeQuota, long statementQuota, boolean offloadingEnabled, long offloadingDataLimit, Path offloadingDataDir, long blockSize) {
        this.statementQuota = statementQuota;
        this.rootMemoryTracker = new MemoryTrackerImpl(nodeQuota, NODE_QUOTA_NAME, GridgainErrorGroups.MemoryQuota.SQL_OUT_OF_MEMORY_ERR, EnabledMemoryTrackingStrategy.memoryQuotaError(NODE_QUOTA_NAME));
        if (offloadingEnabled) {
            this.rootFileDataTracker = new MemoryTrackerImpl(offloadingDataLimit, OFFLOADING_DATA_LIMIT, GridgainErrorGroups.MemoryQuota.DISK_QUOTA_EXCEEDED_ERR, EnabledMemoryTrackingStrategy.memoryQuotaError(OFFLOADING_DATA_LIMIT));
            this.rootFileTracker = new FileIoTrackerImpl(NoOpMemoryTracker.create());
        } else {
            this.rootFileDataTracker = null;
            this.rootFileTracker = null;
        }
        this.offloadingEnabled = offloadingEnabled;
        this.offloadingDataLimit = offloadingDataLimit;
        this.offloadingDataDir = offloadingDataDir;
        this.blockSize = blockSize;
    }

    @Override
    MemoryContextFactory<RowT> newFragmentMemoryContextFactory() {
        return new ActiveMemoryContextFactory(this);
    }

    @Override
    boolean memoryQuotaEnabled() {
        return true;
    }

    @Override
    public long reserved() {
        return this.rootMemoryTracker.reserved();
    }

    @Override
    public long maxReserved() {
        return this.rootMemoryTracker.maxReserved();
    }

    @Override
    boolean offloadingEnabled() {
        return this.offloadingEnabled;
    }

    @Override
    public long offloaded() {
        if (this.rootFileDataTracker == null) {
            return 0L;
        }
        return this.rootFileDataTracker.reserved();
    }

    @Override
    public long maxOffloaded() {
        if (this.rootFileDataTracker == null) {
            return 0L;
        }
        return this.rootFileDataTracker.maxReserved();
    }

    @Override
    public int openFiles() {
        if (this.rootFileTracker == null) {
            return 0;
        }
        return this.rootFileTracker.openedFds();
    }

    @Override
    public long reads() {
        if (this.rootFileTracker == null) {
            return 0L;
        }
        return this.rootFileTracker.totalReadOperations();
    }

    @Override
    public long writes() {
        if (this.rootFileTracker == null) {
            return 0L;
        }
        return this.rootFileTracker.totalWriteOperations();
    }

    @Override
    public long bytesRead() {
        if (this.rootFileTracker == null) {
            return 0L;
        }
        return this.rootFileTracker.totalBytesRead();
    }

    @Override
    public long bytesWritten() {
        if (this.rootFileTracker == null) {
            return 0L;
        }
        return this.rootFileTracker.totalBytesWritten();
    }

    @Override
    public int offloadedActiveQueries() {
        return this.activeOffloadedQueries.size();
    }

    @Override
    public long offloadedQueries() {
        return this.offloadedQueriesCount.longValue();
    }

    private void handleOffloadingEvent(ExecutionId executionId, QueryFragmentOffloadingEvent event) {
        switch (event) {
            case SPILLING: {
                if (!this.activeOffloadedQueries.add(executionId)) break;
                this.offloadedQueriesCount.incrementAndGet();
                break;
            }
            case CLOSE: {
                this.activeOffloadedQueries.remove(executionId);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown event " + event);
            }
        }
    }

    private static FileIoTracker createStamentFileIoTracker(MemoryTracker rootFileIoTracker, FileIoTracker rootFileTracker, long dataLimit) {
        MemoryTrackerImpl memoryTracker = new MemoryTrackerImpl(rootFileIoTracker, dataLimit, OFFLOADING_DATA_LIMIT, GridgainErrorGroups.MemoryQuota.DISK_QUOTA_EXCEEDED_ERR, EnabledMemoryTrackingStrategy.memoryQuotaError(OFFLOADING_DATA_LIMIT), 0L);
        return new DelegatedFileIoTrackerImpl(rootFileTracker, memoryTracker);
    }

    private static String memoryQuotaError(String quotaName) {
        return IgniteStringFormatter.format("SQL query ran out of memory: {} was exceeded.", quotaName);
    }

    private static class ActiveMemoryContextFactory<RowT>
    implements MemoryContextFactory<RowT> {
        private final EnabledMemoryTrackingStrategy<RowT> strategy;

        private ActiveMemoryContextFactory(EnabledMemoryTrackingStrategy<RowT> strategy) {
            this.strategy = strategy;
        }

        @Override
        public MemoryContextProvider<RowT> createMemoryContextProvider() {
            return new StatementMemoryContextProvider(this.strategy.rootMemoryTracker, this.strategy.statementQuota, this.strategy.blockSize);
        }

        @Override
        public RowStorageFactory<RowT> createRowStorageFactory(MemoryContext<RowT> memoryContext, ExecutionId executionId, long fragmentId) {
            if (this.strategy.offloadingEnabled) {
                MemoryTracker rootFileIoTracker = this.strategy.rootFileDataTracker;
                String path = IgniteStringFormatter.format("{}_{}_{}", executionId.queryId(), executionId.executionToken(), fragmentId);
                DataDirectory offloadingDir = new DataDirectory(this.strategy.offloadingDataDir.resolve(path));
                if (rootFileIoTracker == null) {
                    return new OffloadAwareStorageFactoryImpl<RowT>(offloadingDir, memoryContext);
                }
                assert (this.strategy.rootFileTracker != null);
                FileIoTracker fileIoTracker = EnabledMemoryTrackingStrategy.createStamentFileIoTracker(rootFileIoTracker, this.strategy.rootFileTracker, this.strategy.offloadingDataLimit);
                return new OffloadAwareStorageFactoryImpl<RowT>(offloadingDir, memoryContext, fileIoTracker, event -> this.strategy.handleOffloadingEvent(executionId, (QueryFragmentOffloadingEvent)((Object)event)));
            }
            return new RowStorageFactoryImpl<RowT>(memoryContext);
        }
    }

    private static class StatementMemoryContextProvider<RowT>
    implements MemoryContextProvider<RowT> {
        private final MemoryTracker statementTracker;
        private final long blockSize;

        private StatementMemoryContextProvider(MemoryTracker rootTracker, long statementQuota, long blockSize) {
            this.statementTracker = new MemoryTrackerImpl(rootTracker, statementQuota, EnabledMemoryTrackingStrategy.STATEMENT_QUOTA_NAME, GridgainErrorGroups.MemoryQuota.STATEMENT_MEMORY_QUOTA_EXCEEDED_ERR, EnabledMemoryTrackingStrategy.memoryQuotaError(EnabledMemoryTrackingStrategy.STATEMENT_QUOTA_NAME), blockSize);
            this.blockSize = Math.min(blockSize, statementQuota);
        }

        @Override
        public MemoryContext<RowT> create() {
            MemoryTrackerImpl fragmentTracker = new MemoryTrackerImpl(this.statementTracker, 0L, EnabledMemoryTrackingStrategy.STATEMENT_QUOTA_NAME, GridgainErrorGroups.MemoryQuota.STATEMENT_MEMORY_QUOTA_EXCEEDED_ERR, EnabledMemoryTrackingStrategy.memoryQuotaError(EnabledMemoryTrackingStrategy.STATEMENT_QUOTA_NAME), this.blockSize);
            InlineReferenceCounter refCounter = new InlineReferenceCounter();
            return new MemoryContextImpl<SqlRowHandler.RowWrapper>(fragmentTracker, refCounter);
        }

        @Override
        public void close() {
            this.statementTracker.close();
        }
    }
}

