/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.fsm;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.ignite3.internal.sql.engine.InternalSqlRow;
import org.apache.ignite3.internal.sql.engine.QueryCancelledException;
import org.apache.ignite3.internal.sql.engine.SqlOperationContext;
import org.apache.ignite3.internal.sql.engine.exec.AsyncDataCursor;
import org.apache.ignite3.internal.sql.engine.exec.fsm.ExecutionPhaseHandler;
import org.apache.ignite3.internal.sql.engine.exec.fsm.Query;
import org.apache.ignite3.internal.sql.engine.exec.fsm.Result;
import org.apache.ignite3.internal.sql.engine.prepare.QueryPlan;
import org.apache.ignite3.internal.util.CompletableFutures;

class CursorInitializationPhaseHandler
implements ExecutionPhaseHandler {
    static final ExecutionPhaseHandler INSTANCE = new CursorInitializationPhaseHandler();

    private CursorInitializationPhaseHandler() {
    }

    @Override
    public Result handle(Query query) {
        QueryPlan plan = query.plan;
        SqlOperationContext context = query.operationContext;
        assert (plan != null);
        assert (context != null);
        query.cancel.throwIfCancelled();
        CompletionStage awaitFuture = query.executor.executePlan(context, plan).thenCompose(dataCursor -> {
            try {
                query.executor.createAndSaveSqlCursor(query, (AsyncDataCursor<InternalSqlRow>)dataCursor);
                return CompletableFutures.nullCompletedFuture();
            }
            catch (QueryCancelledException ignored) {
                return dataCursor.onClose();
            }
        });
        return Result.proceedAfter((CompletableFuture<Void>)awaitFuture);
    }
}

