/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.exp;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.CatchBlock;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.MethodDeclaration;
import org.apache.calcite.linq4j.tree.NewExpression;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.RowHandler;
import org.apache.ignite3.internal.sql.engine.exec.exp.BiFieldGetter;
import org.apache.ignite3.internal.sql.engine.exec.exp.CorrelatesBuilder;
import org.apache.ignite3.internal.sql.engine.exec.exp.ExpressionFactoryImpl;
import org.apache.ignite3.internal.sql.engine.exec.exp.RexToLixTranslator;
import org.apache.ignite3.internal.sql.engine.exec.exp.SqlJoinProjection;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.internal.sql.engine.util.IgniteMethod;
import org.apache.ignite3.internal.sql.engine.util.TypeUtils;
import org.apache.ignite3.internal.sql.engine.util.cache.Cache;
import org.apache.ignite3.internal.type.StructNativeType;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.sql.SqlException;

class JoinProjectionImplementor {
    private final Cache<String, Object> cache;
    private final RexBuilder rexBuilder;
    private final JavaTypeFactory typeFactory;
    private final SqlConformance conformance;

    JoinProjectionImplementor(Cache<String, Object> cache, RexBuilder rexBuilder, JavaTypeFactory typeFactory, SqlConformance conformance) {
        this.cache = cache;
        this.rexBuilder = rexBuilder;
        this.typeFactory = typeFactory;
        this.conformance = conformance;
    }

    SqlJoinProjection implement(List<RexNode> projections, RelDataType type, int firstRowSize) {
        String digest = ExpressionFactoryImpl.digest(SqlJoinProjection.class, projections, type, "firstRowSize=" + firstRowSize);
        Cache cache = (Cache)Commons.cast(this.cache);
        return cache.get(digest, key -> {
            SqlJoinProjectionExt projectionExt = this.implementInternal(projections, type, firstRowSize);
            return new SqlJoinProjectionImpl(projectionExt, TypeUtils.structuredTypeFromRelTypeList(RexUtil.types((List)projections)));
        });
    }

    private SqlJoinProjectionExt implementInternal(List<RexNode> projections, RelDataType type, int firstRowSize) {
        RexProgramBuilder programBuilder = new RexProgramBuilder(type, this.rexBuilder);
        for (RexNode node : projections) {
            assert (node != null) : "unexpected nullable node";
            programBuilder.addProject(node, null);
        }
        RexProgram program = programBuilder.getProgram();
        BlockBuilder builder = new BlockBuilder();
        ParameterExpression ctx = Expressions.parameter(ExecutionContext.class, (String)"ctx");
        ParameterExpression left = Expressions.parameter(Object.class, (String)"left");
        ParameterExpression right = Expressions.parameter(Object.class, (String)"right");
        ParameterExpression outBuilder = Expressions.parameter(RowHandler.RowBuilder.class, (String)"outBuilder");
        builder.add((Statement)Expressions.declare((int)16, (ParameterExpression)DataContext.ROOT, (Expression)Expressions.convert_((Expression)ctx, DataContext.class)));
        Expression rowHandler = builder.append("hnd", (Expression)Expressions.call((Expression)ctx, (Method)IgniteMethod.CONTEXT_ROW_HANDLER.method(), (Expression[])new Expression[0]));
        BiFieldGetter inputGetter = new BiFieldGetter(rowHandler, (Expression)left, (Expression)right, type, firstRowSize);
        Function1<String, RexToLixTranslator.InputGetter> correlates = new CorrelatesBuilder(builder, (Expression)ctx, rowHandler).build(projections);
        List<Expression> projects = RexToLixTranslator.translateProjects(program, this.typeFactory, this.conformance, builder, null, null, (Expression)ctx, inputGetter, correlates);
        for (Expression val : projects) {
            MethodCallExpression addRowField = Expressions.call((Expression)outBuilder, (Method)IgniteMethod.ROW_BUILDER_ADD_FIELD.method(), (Expression[])new Expression[]{val});
            builder.add(Expressions.statement((Expression)addRowField));
        }
        ParameterExpression ex = Expressions.parameter((int)0, Exception.class, (String)"e");
        NewExpression sqlException = Expressions.new_(SqlException.class, (Expression[])new Expression[]{Expressions.constant((Object)ErrorGroups.Sql.RUNTIME_ERR), ex});
        BlockBuilder tryCatchBlock = new BlockBuilder();
        tryCatchBlock.add((Statement)Expressions.tryCatch((Statement)builder.toBlock(), (CatchBlock[])new CatchBlock[]{Expressions.catch_((ParameterExpression)ex, (Statement)Expressions.throw_((Expression)sqlException))}));
        List<ParameterExpression> params = List.of(ctx, left, right, outBuilder);
        MethodDeclaration declaration = Expressions.methodDecl((int)1, Void.TYPE, (String)"project", params, (BlockStatement)tryCatchBlock.toBlock());
        Class clazz = (Class)Commons.cast(SqlJoinProjectionExt.class);
        String body = Expressions.toString(List.of(declaration), (String)"\n", (boolean)false);
        return (SqlJoinProjectionExt)Commons.compile(clazz, body);
    }

    @FunctionalInterface
    public static interface SqlJoinProjectionExt {
        public <RowT> void project(ExecutionContext<RowT> var1, RowT var2, RowT var3, RowHandler.RowBuilder<RowT> var4);
    }

    private static class SqlJoinProjectionImpl
    implements SqlJoinProjection {
        private final SqlJoinProjectionExt projection;
        private final StructNativeType rowType;

        private SqlJoinProjectionImpl(SqlJoinProjectionExt projection, StructNativeType rowType) {
            this.projection = projection;
            this.rowType = rowType;
        }

        private <RowT> RowHandler.RowBuilder<RowT> builder(ExecutionContext<RowT> context) {
            return context.rowHandler().factory(this.rowType).rowBuilder();
        }

        @Override
        public <RowT> RowT project(ExecutionContext<RowT> context, RowT left, RowT right) {
            RowHandler.RowBuilder<RowT> rowBuilder = this.builder(context);
            this.projection.project(context, left, right, rowBuilder);
            return rowBuilder.buildAndReset();
        }
    }
}

