/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.exp;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.CatchBlock;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodDeclaration;
import org.apache.calcite.linq4j.tree.NewExpression;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.exp.BiFieldGetter;
import org.apache.ignite3.internal.sql.engine.exec.exp.CorrelatesBuilder;
import org.apache.ignite3.internal.sql.engine.exec.exp.ExpressionFactoryImpl;
import org.apache.ignite3.internal.sql.engine.exec.exp.RexToLixTranslator;
import org.apache.ignite3.internal.sql.engine.exec.exp.SqlJoinPredicate;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.internal.sql.engine.util.IgniteMethod;
import org.apache.ignite3.internal.sql.engine.util.cache.Cache;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.sql.SqlException;

class JoinPredicateImplementor {
    private final Cache<String, Object> cache;
    private final RexBuilder rexBuilder;
    private final JavaTypeFactory typeFactory;
    private final SqlConformance conformance;

    JoinPredicateImplementor(Cache<String, Object> cache, RexBuilder rexBuilder, JavaTypeFactory typeFactory, SqlConformance conformance) {
        this.cache = cache;
        this.rexBuilder = rexBuilder;
        this.typeFactory = typeFactory;
        this.conformance = conformance;
    }

    SqlJoinPredicate implement(RexNode predicateExpression, RelDataType type, int firstRowSize) {
        String digest = ExpressionFactoryImpl.digest(SqlJoinPredicate.class, List.of(predicateExpression), type, "firstRowSize=" + firstRowSize);
        Cache cache = (Cache)Commons.cast(this.cache);
        return cache.get(digest, ignored -> this.implementInternal(predicateExpression, type, firstRowSize));
    }

    private SqlJoinPredicate implementInternal(RexNode predicateExpression, RelDataType type, int firstRowSize) {
        RexProgramBuilder programBuilder = new RexProgramBuilder(type, this.rexBuilder);
        programBuilder.addCondition(predicateExpression);
        RexProgram program = programBuilder.getProgram();
        BlockBuilder builder = new BlockBuilder();
        ParameterExpression ctx = Expressions.parameter(ExecutionContext.class, (String)"ctx");
        ParameterExpression left = Expressions.parameter(Object.class, (String)"left");
        ParameterExpression right = Expressions.parameter(Object.class, (String)"right");
        builder.add((Statement)Expressions.declare((int)16, (ParameterExpression)DataContext.ROOT, (Expression)Expressions.convert_((Expression)ctx, DataContext.class)));
        Expression rowHandler = builder.append("hnd", (Expression)Expressions.call((Expression)ctx, (Method)IgniteMethod.CONTEXT_ROW_HANDLER.method(), (Expression[])new Expression[0]));
        BiFieldGetter inputGetter = new BiFieldGetter(rowHandler, (Expression)left, (Expression)right, type, firstRowSize);
        Function1<String, RexToLixTranslator.InputGetter> correlates = new CorrelatesBuilder(builder, (Expression)ctx, rowHandler).build(List.of(predicateExpression));
        Expression condition = RexToLixTranslator.translateCondition(program, this.typeFactory, builder, inputGetter, correlates, this.conformance, (Expression)ctx);
        builder.add(condition);
        ParameterExpression ex = Expressions.parameter((int)0, Exception.class, (String)"e");
        NewExpression sqlException = Expressions.new_(SqlException.class, (Expression[])new Expression[]{Expressions.constant((Object)ErrorGroups.Sql.RUNTIME_ERR), ex});
        BlockBuilder tryCatchBlock = new BlockBuilder();
        tryCatchBlock.add((Statement)Expressions.tryCatch((Statement)builder.toBlock(), (CatchBlock[])new CatchBlock[]{Expressions.catch_((ParameterExpression)ex, (Statement)Expressions.throw_((Expression)sqlException))}));
        List<ParameterExpression> params = List.of(ctx, left, right);
        MethodDeclaration declaration = Expressions.methodDecl((int)1, Boolean.TYPE, (String)"test", params, (BlockStatement)tryCatchBlock.toBlock());
        Class clazz = (Class)Commons.cast(SqlJoinPredicate.class);
        String body = Expressions.toString(List.of(declaration), (String)"\n", (boolean)false);
        return (SqlJoinPredicate)Commons.compile(clazz, body);
    }
}

