/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.schema.SchemaRegistry;
import org.apache.ignite3.internal.sql.engine.exec.ProjectedTableRowConverterImpl;
import org.apache.ignite3.internal.sql.engine.exec.TableRowConverter;
import org.apache.ignite3.internal.sql.engine.exec.TableRowConverterFactory;
import org.apache.ignite3.internal.sql.engine.exec.TableRowConverterImpl;
import org.apache.ignite3.internal.sql.engine.exec.VirtualColumn;
import org.apache.ignite3.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite3.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.sql.ColumnType;
import org.jetbrains.annotations.Nullable;

public class TableRowConverterFactoryImpl
implements TableRowConverterFactory {
    private final SchemaRegistry schemaRegistry;
    private final SchemaDescriptor schemaDescriptor;
    private final TableRowConverter fullRowConverter;
    private final int[] tableColumnSet;
    private final Int2ObjectArrayMap<IntFunction<VirtualColumn>> virtualColumnsFactory = new Int2ObjectArrayMap();

    public TableRowConverterFactoryImpl(TableDescriptor tableDescriptor, SchemaRegistry schemaRegistry, SchemaDescriptor schemaDescriptor) {
        this.schemaRegistry = schemaRegistry;
        this.schemaDescriptor = schemaDescriptor;
        this.fullRowConverter = new TableRowConverterImpl(schemaRegistry, schemaDescriptor);
        this.tableColumnSet = IntStream.range(0, tableDescriptor.columnsCount()).toArray();
        this.addVirtualColumn(tableDescriptor.columnDescriptor("__PARTITION_ID"));
        this.addVirtualColumn(tableDescriptor.columnDescriptor("__PART"));
        this.addVirtualColumn(tableDescriptor.columnDescriptor("__part"));
    }

    private void addVirtualColumn(@Nullable ColumnDescriptor columnDescriptor) {
        if (columnDescriptor == null) {
            return;
        }
        assert (columnDescriptor.virtual());
        int columnIndex = columnDescriptor.logicalIndex();
        ColumnType type = columnDescriptor.physicalType().spec();
        assert (type == ColumnType.INT64 || type == ColumnType.INT32) : "Unsupported type " + type;
        IntFunction<VirtualColumn> columnFactory = type == ColumnType.INT64 ? partId -> new VirtualColumn(columnIndex, columnDescriptor.physicalType(), false, partId) : partId -> new VirtualColumn(columnIndex, columnDescriptor.physicalType(), false, partId);
        this.virtualColumnsFactory.put(columnIndex, columnFactory);
    }

    @Override
    public TableRowConverter create(int @Nullable [] projection) {
        if (projection == null) {
            return this.fullRowConverter;
        }
        return this.create(projection, -1);
    }

    @Override
    public TableRowConverter create(int @Nullable [] projection, int partId) {
        int[] mapping;
        int[] nArray = mapping = projection == null ? this.tableColumnSet : projection;
        if (Commons.isIdentityMapping(mapping, this.schemaDescriptor.length())) {
            return this.fullRowConverter;
        }
        Int2ObjectMap<VirtualColumn> extraColumns = this.createVirtualColumns(mapping, partId);
        return new ProjectedTableRowConverterImpl(this.schemaRegistry, this.schemaDescriptor, mapping, extraColumns);
    }

    private Int2ObjectMap<VirtualColumn> createVirtualColumns(int[] requiredColumns, int partId) {
        if (this.virtualColumnsFactory.isEmpty()) {
            return Int2ObjectMaps.emptyMap();
        }
        Int2ObjectArrayMap columnsMap = new Int2ObjectArrayMap(this.virtualColumnsFactory.size());
        for (int i : requiredColumns) {
            if (i < this.schemaDescriptor.length()) continue;
            columnsMap.put(i, (Object)((VirtualColumn)((IntFunction)this.virtualColumnsFactory.get(i)).apply(partId)));
        }
        return columnsMap;
    }
}

