/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec;

import java.util.IdentityHashMap;
import org.apache.ignite3.internal.sql.engine.exec.ReferenceCounter;
import org.jetbrains.annotations.Nullable;

public class IdentityHashMapReferenceCounter<RowT>
implements ReferenceCounter<RowT> {
    @Nullable
    private IdentityHashMap<RowT, State> counts = new IdentityHashMap();

    @Override
    public int acquire(RowT row) {
        assert (this.counts != null) : "Reference counter is closed";
        State state = this.counts.computeIfAbsent(row, k -> new State());
        ++state.refCnt;
        return state.refCnt;
    }

    @Override
    public int release(RowT row) {
        assert (this.counts != null) : "Reference counter is closed";
        State state = this.counts.get(row);
        assert (state != null) : "No counts for " + row + " total counts: " + this.counts.size();
        assert (state.refCnt > 0) : "Ref count is zero: " + row.getClass().getSimpleName() + "#" + System.identityHashCode(row);
        --state.refCnt;
        return state.refCnt;
    }

    @Override
    public void close() {
        this.counts = null;
    }

    private static class State {
        int refCnt;

        private State() {
        }
    }
}

