/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.lang.RunnableX;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.sql.engine.exec.DynamicPartitionProvider;
import org.apache.ignite3.internal.sql.engine.exec.ExecutableTableRegistry;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionId;
import org.apache.ignite3.internal.sql.engine.exec.PartitionProvider;
import org.apache.ignite3.internal.sql.engine.exec.QueryTaskExecutor;
import org.apache.ignite3.internal.sql.engine.exec.RowHandler;
import org.apache.ignite3.internal.sql.engine.exec.SharedState;
import org.apache.ignite3.internal.sql.engine.exec.StaticPartitionProvider;
import org.apache.ignite3.internal.sql.engine.exec.TxAttributes;
import org.apache.ignite3.internal.sql.engine.exec.exp.ExpressionFactory;
import org.apache.ignite3.internal.sql.engine.exec.mapping.ColocationGroup;
import org.apache.ignite3.internal.sql.engine.exec.mapping.FragmentDescription;
import org.apache.ignite3.internal.sql.engine.exec.memory.MemoryContext;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.RowStorageFactory;
import org.apache.ignite3.internal.sql.engine.prepare.pruning.PartitionPruningColumns;
import org.apache.ignite3.internal.sql.engine.prepare.pruning.PartitionPruningMetadata;
import org.apache.ignite3.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite3.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite3.internal.sql.engine.util.TypeUtils;
import org.apache.ignite3.internal.type.NativeType;
import org.apache.ignite3.internal.type.NativeTypes;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.IgniteCheckedException;
import org.apache.ignite3.lang.IgniteException;
import org.jetbrains.annotations.Nullable;

public class ExecutionContext<RowT>
implements DataContext {
    private static final IgniteLogger LOG = Loggers.forClass(ExecutionContext.class);
    private static final Locale LOCALE = Locale.ENGLISH;
    private final int inBufSize;
    private final QueryTaskExecutor executor;
    private final ExecutionId executionId;
    private final FragmentDescription description;
    private final Map<String, Object> params;
    private final InternalClusterNode localNode;
    private final String originatingNodeName;
    private final UUID originatingNodeId;
    private final RowHandler<RowT> handler;
    private final ExpressionFactory expressionFactory;
    private final AtomicBoolean cancelFlag = new AtomicBoolean();
    private final AtomicReference<Thread> expectedThread = new AtomicReference();
    private final long startTs;
    private final long startTsUtc;
    private final long startTsWithTzOffset;
    private final TxAttributes txAttributes;
    private final ZoneId timeZoneId;
    private final String currentUser;
    private SharedState sharedState = new SharedState();
    @Nullable
    private final Long topologyVersion;
    private final MemoryContext<RowT> memoryContext;
    private final ExecutableTableRegistry tableRegistry;
    @Nullable
    private final RowStorageFactory<RowT> storageFactory;

    public ExecutionContext(ExpressionFactory expressionFactory, QueryTaskExecutor executor, ExecutionId executionId, InternalClusterNode localNode, String originatingNodeName, UUID originatingNodeId, FragmentDescription description, RowHandler<RowT> handler, Map<String, Object> params, TxAttributes txAttributes, ZoneId timeZoneId, MemoryContext<RowT> memoryContext, @Nullable RowStorageFactory<RowT> storageFactory, ExecutableTableRegistry tableRegistry, int inBufSize, Clock clock, @Nullable String username, @Nullable Long topologyVersion) {
        this.expressionFactory = expressionFactory;
        this.executor = executor;
        this.executionId = executionId;
        this.description = description;
        this.handler = handler;
        this.params = params;
        this.localNode = localNode;
        this.originatingNodeName = originatingNodeName;
        this.originatingNodeId = originatingNodeId;
        this.txAttributes = txAttributes;
        this.timeZoneId = timeZoneId;
        this.memoryContext = memoryContext;
        this.tableRegistry = tableRegistry;
        this.storageFactory = storageFactory;
        this.inBufSize = inBufSize < 0 ? 512 : inBufSize;
        this.currentUser = username;
        this.topologyVersion = topologyVersion;
        assert (this.inBufSize > 0) : this.inBufSize;
        Instant nowUtc = Instant.now(clock);
        this.startTsUtc = nowUtc.toEpochMilli();
        this.startTs = nowUtc.toEpochMilli();
        this.startTsWithTzOffset = nowUtc.plusSeconds(this.timeZoneId.getRules().getOffset(nowUtc).getTotalSeconds()).toEpochMilli();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Context created [executionId={}, fragmentId={}]", executionId, this.fragmentId());
        }
    }

    public UUID queryId() {
        return this.executionId.queryId();
    }

    public int executionToken() {
        return this.executionId.executionToken();
    }

    public ExecutionId executionId() {
        return this.executionId;
    }

    public long fragmentId() {
        return this.description.fragmentId();
    }

    @Nullable
    public ColocationGroup target() {
        return this.description.target();
    }

    public FragmentDescription description() {
        return this.description;
    }

    @Nullable
    public List<String> remotes(long exchangeId) {
        return this.description.remotes(exchangeId);
    }

    @Nullable
    public ColocationGroup group(long sourceId) {
        return this.description.group(sourceId);
    }

    public RowHandler<RowT> rowHandler() {
        return this.handler;
    }

    public ExpressionFactory expressionFactory() {
        return this.expressionFactory;
    }

    public String originatingNodeName() {
        return this.originatingNodeName;
    }

    public UUID originatingNodeId() {
        return this.originatingNodeId;
    }

    public InternalClusterNode localNode() {
        return this.localNode;
    }

    public ExecutableTableRegistry tableRegistry() {
        return this.tableRegistry;
    }

    public int bufferSize() {
        return this.inBufSize;
    }

    public SchemaPlus getRootSchema() {
        throw new AssertionError((Object)"should not be called");
    }

    public IgniteTypeFactory getTypeFactory() {
        return IgniteTypeFactory.INSTANCE;
    }

    public QueryProvider getQueryProvider() {
        throw new AssertionError((Object)"should not be called");
    }

    @Nullable
    public Object get(String name) {
        if (DataContext.Variable.CANCEL_FLAG.camelName.equals(name)) {
            return this.cancelFlag;
        }
        if (DataContext.Variable.UTC_TIMESTAMP.camelName.equals(name)) {
            return this.startTsUtc;
        }
        if (DataContext.Variable.CURRENT_TIMESTAMP.camelName.equals(name)) {
            return this.startTs;
        }
        if (DataContext.Variable.LOCAL_TIMESTAMP.camelName.equals(name)) {
            return this.startTsWithTzOffset;
        }
        if (DataContext.Variable.LOCALE.camelName.equals(name)) {
            return LOCALE;
        }
        if (DataContext.Variable.TIME_ZONE.camelName.equals(name)) {
            return TimeZone.getTimeZone(this.timeZoneId);
        }
        if (DataContext.Variable.USER.camelName.equals(name)) {
            return this.currentUser;
        }
        if (name.startsWith("?")) {
            return this.getParameter(name);
        }
        return this.params.get(name);
    }

    @Nullable
    public Long topologyVersion() {
        return this.topologyVersion;
    }

    @Nullable
    private Object getParameter(String name) {
        assert (name.startsWith("?")) : name;
        Object param = this.params.get(name);
        if (param == null) {
            if (!this.params.containsKey(name)) {
                throw new IllegalStateException("Missing dynamic parameter: " + name);
            }
            return null;
        }
        NativeType nativeType = NativeTypes.fromObject(param);
        if (nativeType == null) {
            throw new IllegalArgumentException(IgniteStringFormatter.format("Dynamic parameter of unsupported type: parameterName={}, type={}", name, param.getClass()));
        }
        return TypeUtils.toInternal(param, nativeType.spec());
    }

    public Object correlatedVariable(int id) {
        return this.sharedState.correlatedVariable(id);
    }

    public void correlatedVariable(Object value, int id) {
        this.sharedState.correlatedVariable(id, value);
    }

    public void sharedState(SharedState state) {
        this.sharedState = state;
    }

    public SharedState sharedState() {
        return this.sharedState;
    }

    public void execute(RunnableX task, Consumer<Throwable> onError) {
        if (this.isCancelled()) {
            return;
        }
        this.executor.execute(this.queryId(), this.fragmentId(), () -> {
            try {
                this.assertThread();
                if (!this.isCancelled()) {
                    task.run();
                }
            }
            catch (Throwable e) {
                Throwable unwrappedException = ExceptionUtils.unwrapCause(e);
                onError.accept(unwrappedException);
                if (unwrappedException instanceof IgniteException || unwrappedException instanceof IgniteInternalException || unwrappedException instanceof IgniteCheckedException || unwrappedException instanceof IgniteInternalCheckedException) {
                    return;
                }
                LOG.warn("Unexpected exception", e);
            }
        });
    }

    public CompletableFuture<?> submit(RunnableX task, Consumer<Throwable> onError) {
        assert (!this.isCancelled()) : "Call submit after execution was cancelled.";
        return this.executor.submit(this.queryId(), this.fragmentId(), () -> {
            try {
                this.assertThread();
                task.run();
            }
            catch (Throwable e) {
                onError.accept(e);
                throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Unexpected exception", e);
            }
        });
    }

    public TxAttributes txAttributes() {
        return this.txAttributes;
    }

    public MemoryContext<RowT> memoryContext() {
        return this.memoryContext;
    }

    public RowStorageFactory<RowT> storageFactory() {
        if (this.storageFactory == null) {
            throw new IllegalStateException("ExecutionContext has been created without RowStorageFactory");
        }
        return this.storageFactory;
    }

    public boolean cancel() {
        boolean res;
        boolean bl = res = !this.cancelFlag.get() && this.cancelFlag.compareAndSet(false, true);
        if (res && LOG.isTraceEnabled()) {
            LOG.trace("Context cancelled [executionId={}, fragmentId={}]", this.executionId, this.fragmentId());
        }
        return res;
    }

    public boolean isCancelled() {
        return this.cancelFlag.get();
    }

    public PartitionProvider<RowT> getPartitionProvider(long sourceId, ColocationGroup group, IgniteTable table) {
        PartitionPruningMetadata metadata = this.description.partitionPruningMetadata();
        PartitionPruningColumns columns = metadata != null ? metadata.get(sourceId) : null;
        String nodeName = this.localNode.name();
        if (columns == null) {
            return new StaticPartitionProvider(nodeName, group, sourceId);
        }
        return new DynamicPartitionProvider(nodeName, group.assignments(), columns, table);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionContext context = (ExecutionContext)o;
        return this.executionId.equals(context.executionId) && this.description.fragmentId() == context.description.fragmentId();
    }

    public int hashCode() {
        return Objects.hash(this.executionId, this.description.fragmentId());
    }

    void cleanUp() {
        this.assertThread();
        if (this.storageFactory != null) {
            try {
                this.storageFactory.close();
            }
            catch (Throwable e) {
                LOG.warn("Closing a data storage caused an unexpected exception [queryId={}].", e, this.queryId());
            }
        }
        try {
            this.memoryContext.close();
        }
        catch (Throwable e) {
            LOG.warn("Closing a memory context caused an unexpected exception [queryId={}].", e, this.queryId());
        }
    }

    private void assertThread() {
        Thread expectedThread;
        if (!IgniteUtils.assertionsEnabled()) {
            return;
        }
        Thread currentThread = Thread.currentThread();
        if (!this.expectedThread.compareAndSet(null, currentThread) && (expectedThread = this.expectedThread.get()) != currentThread) {
            throw new AssertionError();
        }
    }
}

