/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import org.apache.ignite3.internal.sql.engine.SqlQueryType;
import org.apache.ignite3.internal.sql.engine.exec.fsm.ExecutionPhase;
import org.apache.ignite3.internal.sql.engine.exec.fsm.QueryExecutor;
import org.apache.ignite3.internal.sql.engine.exec.fsm.QueryInfo;
import org.apache.ignite3.internal.sql.engine.prepare.ExplainablePlan;
import org.apache.ignite3.internal.sql.engine.prepare.PrepareService;
import org.apache.ignite3.internal.sql.engine.prepare.PrepareServiceImpl;
import org.apache.ignite3.internal.sql.engine.prepare.PreparedPlan;
import org.apache.ignite3.internal.sql.engine.prepare.QueryPlan;
import org.apache.ignite3.internal.systemview.api.NodeSystemView;
import org.apache.ignite3.internal.systemview.api.SystemView;
import org.apache.ignite3.internal.systemview.api.SystemViews;
import org.apache.ignite3.internal.type.NativeType;
import org.apache.ignite3.internal.type.NativeTypes;
import org.apache.ignite3.internal.util.SubscriptionUtils;
import org.jetbrains.annotations.Nullable;

public class SqlQueriesViewProvider {
    public static final String SCRIPT_QUERY_TYPE = "Script";
    private static final NativeType TIMESTAMP_TYPE = NativeTypes.timestamp(9);
    private final CompletableFuture<QueryExecutor> queryExecutorFuture = new CompletableFuture();
    private final CompletableFuture<PrepareService> prepareServiceFuture = new CompletableFuture();

    public void init(QueryExecutor queryExecutor, PrepareServiceImpl prepareSvc) {
        this.queryExecutorFuture.complete(queryExecutor);
        this.prepareServiceFuture.complete(prepareSvc);
    }

    public List<SystemView<?>> getViews() {
        return List.of(this.queries(), this.cachedPlans());
    }

    private SystemView<?> queries() {
        Flow.Publisher viewDataPublisher = SubscriptionUtils.fromIterable(this.queryExecutorFuture.thenApply(queryExecutor -> () -> queryExecutor.runningQueries().iterator()));
        NativeType stringType = NativeTypes.stringOf(Short.MAX_VALUE);
        NativeType idType = NativeTypes.stringOf(36);
        return ((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)SystemViews.nodeViewBuilder().name("SQL_QUERIES")).nodeNameColumnAlias("INITIATOR_NODE").addColumn("QUERY_ID", idType, info -> SqlQueriesViewProvider.mapId(info.id()))).addColumn("USERNAME", stringType, QueryInfo::username)).addColumn("QUERY_PHASE", NativeTypes.stringOf(10), info -> SqlQueriesViewProvider.mapPhase(info.phase()))).addColumn("QUERY_TYPE", NativeTypes.stringOf(10), SqlQueriesViewProvider::deriveQueryType)).addColumn("QUERY_DEFAULT_SCHEMA", stringType, QueryInfo::schema)).addColumn("SQL", stringType, QueryInfo::sql)).addColumn("QUERY_START_TIME", TIMESTAMP_TYPE, QueryInfo::startTime)).addColumn("TRANSACTION_ID", idType, info -> SqlQueriesViewProvider.mapId(info.transactionId()))).addColumn("PARENT_QUERY_ID", idType, info -> SqlQueriesViewProvider.mapId(info.parentId()))).addColumn("QUERY_STATEMENT_ORDINAL", NativeTypes.INT32, info -> SqlQueriesViewProvider.mapStatementNum(info.statementNum()))).addColumn("ID", idType, info -> SqlQueriesViewProvider.mapId(info.id()))).addColumn("PHASE", NativeTypes.stringOf(10), info -> SqlQueriesViewProvider.mapPhase(info.phase()))).addColumn("TYPE", NativeTypes.stringOf(10), SqlQueriesViewProvider::deriveQueryType)).addColumn("SCHEMA", stringType, QueryInfo::schema)).addColumn("START_TIME", TIMESTAMP_TYPE, QueryInfo::startTime)).addColumn("PARENT_ID", idType, info -> SqlQueriesViewProvider.mapId(info.parentId()))).addColumn("STATEMENT_NUM", NativeTypes.INT32, info -> SqlQueriesViewProvider.mapStatementNum(info.statementNum()))).dataProvider(viewDataPublisher)).build();
    }

    @Nullable
    private static String mapId(@Nullable UUID id) {
        return id == null ? null : id.toString();
    }

    @Nullable
    private static String deriveQueryType(QueryInfo info) {
        if (info.script()) {
            return SCRIPT_QUERY_TYPE;
        }
        SqlQueryType queryType = info.queryType();
        return queryType == null ? null : SqlQueriesViewProvider.mapQueryType(queryType);
    }

    private static String mapPhase(ExecutionPhase phase) {
        switch (phase) {
            case REGISTERED: 
            case PARSING: {
                return "INITIALIZATION";
            }
            case OPTIMIZING: {
                return "OPTIMIZATION";
            }
            case CURSOR_INITIALIZATION: 
            case CURSOR_PUBLICATION: 
            case SCRIPT_INITIALIZATION: 
            case EXECUTING: {
                return "EXECUTION";
            }
            case TERMINATED: {
                return "TERMINATED";
            }
        }
        throw new AssertionError((Object)("Unknown phase " + phase));
    }

    @Nullable
    private static Integer mapStatementNum(int statementNum) {
        return statementNum >= 0 ? Integer.valueOf(statementNum) : null;
    }

    private SystemView<?> cachedPlans() {
        Flow.Publisher viewDataPublisher = SubscriptionUtils.fromIterable(this.prepareServiceFuture.thenApply(queryExecutor -> () -> queryExecutor.preparedPlans().iterator()));
        return ((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)SystemViews.nodeViewBuilder().name("SQL_CACHED_QUERY_PLANS")).nodeNameColumnAlias("NODE_ID").addColumn("PLAN_ID", NativeTypes.STRING, v -> v.queryPlan().id().toString())).addColumn("CATALOG_VERSION", NativeTypes.INT32, PreparedPlan::catalogVersion)).addColumn("QUERY_DEFAULT_SCHEMA", NativeTypes.STRING, PreparedPlan::defaultSchemaName)).addColumn("SQL", NativeTypes.STRING, PreparedPlan::sql)).addColumn("QUERY_TYPE", NativeTypes.STRING, v -> SqlQueriesViewProvider.mapQueryType(v.queryPlan().type()))).addColumn("QUERY_PLAN", NativeTypes.STRING, v -> SqlQueriesViewProvider.mapQueryPlan(v.queryPlan()))).addColumn("QUERY_PREPARE_TIME", TIMESTAMP_TYPE, PreparedPlan::timestamp)).dataProvider(viewDataPublisher)).build();
    }

    private static String mapQueryType(SqlQueryType type) {
        return type.displayName();
    }

    @Nullable
    private static String mapQueryPlan(QueryPlan plan) {
        if (plan instanceof ExplainablePlan) {
            ExplainablePlan explainablePlan = (ExplainablePlan)plan;
            return explainablePlan.explain();
        }
        return null;
    }
}

