/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.security.authentication.basic;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite3.configuration.NamedListView;
import org.apache.ignite3.configuration.validation.ValidationContext;
import org.apache.ignite3.configuration.validation.ValidationIssue;
import org.apache.ignite3.configuration.validation.Validator;
import org.apache.ignite3.internal.security.authentication.basic.BasicUserView;
import org.apache.ignite3.internal.security.authentication.basic.UserPasswordEncodingValidator;
import org.gridgain.internal.rbac.password.PasswordEncoder;
import org.gridgain.internal.rbac.password.PasswordEncoderRegistry;
import org.gridgain.internal.rbac.password.PasswordEncoding;
import org.jetbrains.annotations.Nullable;

public class UserPasswordEncodingValidatorImpl
implements Validator<UserPasswordEncodingValidator, NamedListView<? extends BasicUserView>> {
    public static final UserPasswordEncodingValidatorImpl INSTANCE = new UserPasswordEncodingValidatorImpl();
    private static final PasswordEncoderRegistry PASSWORD_ENCODER_REGISTRY = PasswordEncoderRegistry.createDefaultRegistry(ForkJoinPool.commonPool());

    @Override
    public void validate(UserPasswordEncodingValidator annotation, ValidationContext<NamedListView<? extends BasicUserView>> ctx) {
        Map<String, ? extends BasicUserView> newValues = UserPasswordEncodingValidatorImpl.toMap(ctx.getNewValue());
        Map<String, ? extends BasicUserView> oldValues = UserPasswordEncodingValidatorImpl.toMap(ctx.getOldValue());
        for (Map.Entry<String, ? extends BasicUserView> entry : newValues.entrySet()) {
            BasicUserView newUserConfiguration = entry.getValue();
            BasicUserView oldUserConfiguration = oldValues.get(entry.getKey());
            UserPasswordEncodingValidatorImpl.validateUserConfiguration(ctx, newUserConfiguration, oldUserConfiguration);
        }
    }

    private static void validateUserConfiguration(ValidationContext<NamedListView<? extends BasicUserView>> ctx, BasicUserView newUserConfiguration, @Nullable BasicUserView oldUserConfiguration) {
        if (oldUserConfiguration != null) {
            boolean isSameEncoding = Objects.equals(newUserConfiguration.passwordEncoding(), oldUserConfiguration.passwordEncoding());
            boolean isSamePassword = Objects.equals(newUserConfiguration.password(), oldUserConfiguration.password());
            if (isSameEncoding && isSamePassword) {
                return;
            }
            if (isSamePassword) {
                ctx.addIssue(new ValidationIssue(ctx.currentKey(), "Changing password encoding without changing the password is not supported."));
            }
        }
        if (!UserPasswordEncodingValidatorImpl.isPasswordLooksLikeEncodedWithSpecificEncoding(newUserConfiguration.password(), newUserConfiguration.passwordEncoding())) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), "Specified user password is not encoded correctly."));
        }
    }

    private static boolean isPasswordLooksLikeEncodedWithSpecificEncoding(String password, String passwordEncoding) {
        PasswordEncoding encoding = PasswordEncoding.valueOf(passwordEncoding.toUpperCase());
        PasswordEncoder passwordEncoder = PASSWORD_ENCODER_REGISTRY.passwordEncoder(encoding);
        return passwordEncoder.isValidFormat(password);
    }

    private static <T> Map<String, T> toMap(@Nullable NamedListView<? extends T> namedListView) {
        if (namedListView == null) {
            return Collections.emptyMap();
        }
        List<String> keys = namedListView.namedListKeys();
        return keys.stream().collect(Collectors.toMap(Function.identity(), namedListView::get));
    }
}

