/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.secondarystoragebridge;

import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.secondarystoragebridge.TransactionInfo;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.secondary.BinaryRowAndRowId;
import org.apache.ignite3.internal.util.Cursor;
import org.jetbrains.annotations.Nullable;

public interface UpdatesStorage {
    public void onNewWrite(UUID var1, RowId var2, BinaryRow var3);

    public void onTransactionAborted(UUID var1);

    public void onTransactionCommitted(UUID var1, HybridTimestamp var2);

    public void dropTransactionData(HybridTimestamp var1, RowId var2);

    public void dropTransactionData(Collection<TransactionInfo> var1);

    public long lastAppliedIndex();

    public long lastAppliedTerm();

    public void lastApplied(long var1, long var3);

    public void updateConfiguration(long var1, long var3, byte[] var5);

    public long persistedIndex();

    public byte @Nullable [] configuration();

    default public Cursor<TransactionInfo> getCommittedTransactionIds(HybridTimestamp upperBound) {
        return this.getCommittedTransactionIds(HybridTimestamp.MIN_VALUE, upperBound);
    }

    public Cursor<TransactionInfo> getCommittedTransactionIds(HybridTimestamp var1, HybridTimestamp var2);

    public Cursor<BinaryRowAndRowId> getTransactionData(UUID var1, @Nullable RowId var2);

    public CompletableFuture<Void> flush();

    public void updateLease(long var1, UUID var3, String var4);

    public long leaseStartTime();

    @Nullable
    public UUID primaryReplicaNodeId();

    @Nullable
    public String primaryReplicaNodeName();

    public boolean hasOngoingTransactions(HybridTimestamp var1);

    public boolean isCommitedStorageEmpty(HybridTimestamp var1);

    public boolean isCommitedStorageLimitReached(HybridTimestamp var1);
}

