/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.restart;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.ignite3.Ignite;
import org.apache.ignite3.internal.restart.IgniteAttachmentLock;
import org.apache.ignite3.internal.restart.RestartProofApiObject;
import org.apache.ignite3.network.ClusterNode;
import org.apache.ignite3.table.Tuple;
import org.apache.ignite3.table.mapper.Mapper;
import org.apache.ignite3.table.partition.Partition;
import org.apache.ignite3.table.partition.PartitionDistribution;
import org.apache.ignite3.table.partition.PartitionManager;

class RestartProofPartitionManager
extends RestartProofApiObject<PartitionDistribution>
implements PartitionManager {
    RestartProofPartitionManager(IgniteAttachmentLock attachmentLock, Ignite initialIgnite, Function<Ignite, PartitionDistribution> factory) {
        super(attachmentLock, initialIgnite, factory);
    }

    @Override
    public CompletableFuture<List<Partition>> partitionsAsync() {
        return this.attachedAsync(PartitionDistribution::partitionsAsync);
    }

    @Override
    public List<Partition> partitions() {
        return this.attached(PartitionDistribution::partitions);
    }

    @Override
    public CompletableFuture<ClusterNode> primaryReplicaAsync(Partition partition) {
        return this.attachedAsync(view -> view.primaryReplicaAsync(partition));
    }

    @Override
    public ClusterNode primaryReplica(Partition partition) {
        return this.attached(view -> view.primaryReplica(partition));
    }

    @Override
    public CompletableFuture<Map<Partition, ClusterNode>> primaryReplicasAsync() {
        return this.attachedAsync(PartitionDistribution::primaryReplicasAsync);
    }

    @Override
    public CompletableFuture<List<Partition>> primaryReplicasAsync(ClusterNode node) {
        return this.attachedAsync(view -> view.primaryReplicasAsync(node));
    }

    @Override
    public Map<Partition, ClusterNode> primaryReplicas() {
        return this.attached(PartitionDistribution::primaryReplicas);
    }

    @Override
    public List<Partition> primaryReplicas(ClusterNode node) {
        return this.attached(view -> view.primaryReplicas(node));
    }

    @Override
    public <K> CompletableFuture<Partition> partitionAsync(K key, Mapper<K> mapper) {
        return this.attachedAsync(view -> view.partitionAsync(key, mapper));
    }

    @Override
    public CompletableFuture<Partition> partitionAsync(Tuple key) {
        return this.attachedAsync(view -> view.partitionAsync(key));
    }

    @Override
    public <K> Partition partition(K key, Mapper<K> mapper) {
        return this.attached(view -> view.partition(key, mapper));
    }

    @Override
    public Partition partition(Tuple key) {
        return this.attached(view -> view.partition(key));
    }
}

