/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.transaction;

import io.micronaut.http.annotation.Controller;
import io.micronaut.security.utils.SecurityService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.rest.ResourceHolder;
import org.apache.ignite3.internal.rest.api.transaction.TransactionApi;
import org.apache.ignite3.internal.rest.api.transaction.TransactionInfo;
import org.apache.ignite3.internal.rest.transaction.exception.TransactionKillException;
import org.apache.ignite3.internal.rest.transaction.exception.TransactionNotFoundException;
import org.apache.ignite3.internal.sql.engine.api.kill.CancellableOperationType;
import org.apache.ignite3.internal.sql.engine.api.kill.KillHandlerRegistry;
import org.apache.ignite3.sql.IgniteSql;
import org.apache.ignite3.sql.SqlRow;
import org.apache.ignite3.sql.Statement;
import org.apache.ignite3.sql.async.AsyncResultSet;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.rbac.privileges.Action;
import org.gridgain.internal.rest.SecurityContextAware;
import org.jetbrains.annotations.Nullable;

@Controller(value="/management/v1/transaction")
public class TransactionController
implements TransactionApi,
ResourceHolder,
SecurityContextAware {
    private static final IgniteLogger LOG = Loggers.forClass(TransactionController.class);
    private IgniteSql igniteSql;
    private KillHandlerRegistry killHandlerRegistry;
    private final SecurityService securityService;
    private Authorizer authorizer;

    public TransactionController(IgniteSql igniteSql, KillHandlerRegistry killHandlerRegistry, SecurityService securityService, Authorizer authorizer) {
        this.igniteSql = igniteSql;
        this.killHandlerRegistry = killHandlerRegistry;
        this.securityService = securityService;
        this.authorizer = authorizer;
    }

    @Override
    public CompletableFuture<Collection<TransactionInfo>> transactions() {
        return this.secured(() -> this.authorizer.authorizeThenCompose(Action.GET_TRANSACTION_STATE, () -> this.transactionInfos()));
    }

    @Override
    public CompletableFuture<TransactionInfo> transaction(UUID transactionId) {
        Supplier<CompletableFuture> getTransaction = () -> this.transactionInfos(transactionId).thenApply(transactionInfos -> {
            Iterator iterator = transactionInfos.iterator();
            if (iterator.hasNext()) {
                return (TransactionInfo)iterator.next();
            }
            throw new TransactionNotFoundException(transactionId.toString());
        });
        return this.secured(() -> this.authorizer.authorizeThenCompose(Action.GET_TRANSACTION_STATE, getTransaction));
    }

    @Override
    public CompletableFuture<Void> killTransaction(UUID transactionId) {
        try {
            Supplier<CompletableFuture> cancelAction = () -> this.killHandlerRegistry.handler(CancellableOperationType.TRANSACTION).cancelAsync(transactionId.toString()).thenApply(result -> TransactionController.handleOperationResult(transactionId, result));
            return this.secured(() -> this.authorizer.authorizeThenCompose(Action.KILL_TRANSACTION, cancelAction));
        }
        catch (Exception e) {
            LOG.error("Transaction {} can't be killed.", transactionId, e);
            return CompletableFuture.failedFuture(new TransactionKillException(transactionId.toString()));
        }
    }

    private static Void handleOperationResult(UUID transactionId, @Nullable Boolean result) {
        if (result != null && !result.booleanValue()) {
            throw new TransactionNotFoundException(transactionId.toString());
        }
        return null;
    }

    @Override
    public void cleanResources() {
        this.igniteSql = null;
        this.killHandlerRegistry = null;
        this.authorizer = null;
    }

    @Override
    public SecurityService securityService() {
        return this.securityService;
    }

    private CompletableFuture<Collection<TransactionInfo>> transactionInfos() {
        return this.transactionInfos("SELECT * FROM SYSTEM.TRANSACTIONS ORDER BY START_TIME");
    }

    private CompletableFuture<Collection<TransactionInfo>> transactionInfos(UUID transactionId) {
        return this.transactionInfos("SELECT * FROM SYSTEM.TRANSACTIONS WHERE ID='" + transactionId.toString() + "'");
    }

    private CompletableFuture<Collection<TransactionInfo>> transactionInfos(String query) {
        Statement transactionStmt = this.igniteSql.createStatement(query);
        return this.igniteSql.executeAsync(null, transactionStmt, new Object[0]).thenCompose(resultSet -> TransactionController.iterate(resultSet, new ArrayList<TransactionInfo>()));
    }

    private static CompletableFuture<Collection<TransactionInfo>> iterate(AsyncResultSet<SqlRow> resultSet, List<TransactionInfo> result) {
        for (SqlRow row : resultSet.currentPage()) {
            result.add(TransactionController.convert(row));
        }
        if (resultSet.hasMorePages()) {
            return resultSet.fetchNextPage().thenCompose(nextPage -> TransactionController.iterate(nextPage, result));
        }
        return CompletableFuture.completedFuture(result);
    }

    private static TransactionInfo convert(SqlRow row) {
        return new TransactionInfo(UUID.fromString(row.stringValue("ID")), row.stringValue("COORDINATOR_NODE_ID"), row.stringValue("STATE"), row.stringValue("TYPE"), row.stringValue("PRIORITY"), row.timestampValue("START_TIME"));
    }
}

